@extends('layouts.main')
@section('title', 'Booking | Select Resource')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Create something with us!')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/booking-banner.png')}}">
</div>

<section class="visible">
    <div class="container text-dark mt-3" data-aos="fade-up">
        @if (session('error'))
        <div class="row"><div class="alert alert-danger">{{session('error')}}</div></div>
        @endif
        <div class="row">
            <div class="col-md-8">
                @if($resources->count() > 0)
                <h2 class="mb-4">Select additional support</h2>
                @foreach($resources as $resource)
                <div class="row col-md-12 mt-3 @if(!$resource->available) text-muted @endif">
                    <div class="col-md-1">
                        <div>
                            <input id="checkbox-{{$loop->index}}" class="checkbox-custom" value="{{$resource->id}}" name="booking_resource" type="radio" data-type="resource" data-days="{{$resource->booking_days}}" data-hours="{{$resource->booking_hours}}" @if(session()->has('temp-booking-resource-selection') && session()->get('temp-booking-resource-selection')==$resource->id)checked @endif @if(!$resource->available) disabled @endif>
                            <label for="checkbox-{{$loop->index}}" class="checkbox-custom-label"></label>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <h3>{{$resource->fname}} {{$resource->lname}}</h3>
                        @if(isset($resource->resourceName->name))<h5 class="txtgray">{{$resource->resourceName->name}}</h5>@endif
                        @if($resource->description)
                        <b>Description</b>
                        <div class="mt-2">{{$resource->description}}</div>
                        @endif
                        @if(!$resource->available)
                        <p>resource is booked at this time please select different time. <span class="text-primary pointer check-availability">check availability</span></p>
                        <div class="availability-calendar" data-id="{{$resource->id}}" data-type="resource"></div>
                        @endif
                    </div>
                    <div class="col-md-2">
                        <h3>{{$resource->resource_points}}pts</h3>
                    </div>
                    <div class="col-md-4">
                        <div class="imgbox">
                            @if($resource->profile_pic)
                            <img src="{{url('storage/profile-pic/'.$resource->profile_pic)}}" class="imgfluidlogged @if(!$resource->available) opacity-50 @endif" />
                            @else
                            <img src="{{url('images/user-img.png')}}" class="imgfluidlogged @if(!$resource->available) opacity-50 @endif" />
                            @endif
                        </div>
                    </div>
                </div>
                @endforeach
                <div class="row col-md-12 mt-5">
                    <div class="foot-paging">
                    {!! $resources->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                    </div>
                </div>
                @else
                <h2 class="mt-4">Resources are not available this time.</h2>
                @endif
            </div>
            <div class="col-md-4 p-0">
                @include('frontend.booking.booking-form')
            </div>
        </div>
    </div>
</section>
@endsection

@section('footer_scripts')
<script>
    $(document).ready(function () {
        
    });
</script>
@endsection
