@extends('layouts.settings')
  @section('title', 'Nomadic - Equipment Checkin')
  @section('content')
  <div class="banner"></div>
  <div class="container position-relative" data-aos="fade-up" style="top:50px;padding-bottom:30px;">
    <h2 class="mt-4 mb-5">{{__('Equipment Checkin Process')}}</h2>
    @if (session('error'))
    <div class="alert alert-danger p-2">{{session('error')}}</div>
    @elseif (session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif
  
    <div class="row mb-5 d-block">
      <div class="col-xl-12">
        <div class="row">
          <div class="col-xl-3">
            <label class="lblprofile">Equipment Details </label>
          </div>
          <div class="col-xl-6 mt-4">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                @if(!empty($data->equipment_photo))
                <img src="{{asset('storage/rental')}}/{{$data->equipment_photo}}" class="img-fluid w-100" style="border-radius: 5px;">
                @else
                <img src="{{asset('images/user-img.png')}}" class="img-fluid w-100" style="border-radius: 5px;">
                @endif
              </div>
            </div>
            <div class="row">
              <div class="col-md-3" style="font-weight:600;">Name</div>
              <div class="col-md-4">{{$data->equipment_name}}</div>
            </div>
            <div class="row mt-2">
              <div class="col-md-3" style="font-weight:600;">Serial Number</div>
              <div class="col-md-4">{{$data->serial_number}}</div>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-xl-3">
            <label class="lblprofile">Checkout Photos</label>
          </div>
          <div class="col-xl-6 mt-4">
            <div id="checkoutimages" class="row mt-3">{!! $checkout_content !!}</div>
          </div>
        </div>

        <div class="row">
          <div class="col-xl-3">
            <label class="lblprofile">Checkout Comments</label>
          </div>
          <div class="col-xl-6 mt-4">{{$data->description}}</div>
        </div>

        <div class="row">
          <div class="col-xl-3">
            <label class="lblprofile">Upload Photos</label>
          </div>
          <div class="col-xl-6 mt-4">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="hidden" id="checkin_id" value="{{$data->id}}" readonly />
                <input type="hidden" id="lpid" value="{{$sessionId}}" readonly />
                <input type="hidden" id="booking_id" value="{{$data->booking_id}}" readonly />
                <input type="hidden" id="equipment_id" value="{{$data->equipment_id}}" readonly />
                <form action="{{url('fileupload')}}" method="post" enctype="multipart/form-data" id="equip_checkin" class="dropzone">
                  @csrf
                  <input type="hidden" id="location_id" name="location_id" value="{{$data->location_id}}" readonly>
                  <input type="hidden" id="type" name="type" value="equip_checkin" readonly>
                  <input type="hidden" name="image_type" value="photos" readonly>
                </form>
                <div id="checkinimages" class="row mt-3">{!! $checkin_content !!}</div>
              </div>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-xl-3">
            <label class="lblprofile">Checkin Comments</label>
          </div>
          <div class="col-xl-6 mt-4">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <textarea id="checkin_comments" class="form-control txtarea mb-3" rows="8"></textarea>
              </div>
            </div>
          </div>
        </div>

        <div class="row mt-3">
          <div class="col-md-6 text-end">
            <input id="btn_savecheckin" type="button" class="btn btn-primary mb-2 mt-4" value="Checkin">
          </div>
        </div>
        
      </div>
    </div>
  </div>

  @endsection
  @section('footer_scripts')
  <link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
  <link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
  <script src="{{asset('js/dropzone.js')}}"></script>
  <script>
    // checkout photos
    Dropzone.autoDiscover = false;
    var myDropzone2 = new Dropzone("#equip_checkin",{ 
        maxFiles: 10,
        maxFilesize: 100,
        autoProcessQueue: true,
        uploadMultiple: false, 
        addRemoveLinks: true,
        acceptedFiles: ".jpeg,.jpg,.png",
    });
    myDropzone2.on("sending", function(file, xhr, formData) {
        
    });
    myDropzone2.on("uploadprogress", function (file, progress) {
        $('.progress-text').html(parseInt(progress)+'%');
    });
    myDropzone2.on("error", function (file, errorMessage) {
        $('.progress-text').html('0%').hide();
    });
    myDropzone2.on("success", function (file, response) {
        $('.progress-text').html('0%').hide();
        myDropzone2.removeAllFiles(true);
        if(response.status) {
            $('#checkinimages').append(response.content);
        }
    });
  
    $(document).ready(function () {
      $(document).on("click", "#btn_savecheckin", function () {
        let checkin_id = $("#checkin_id").val();
        let checkin_comments = $("#checkin_comments").val();
        $.ajax({
            type: "POST",
            dataType: "json",
            data: {
              _token: _token,
              checkin_id: checkin_id,
              checkin_comments:checkin_comments
            },
            url: APP_URL + "/equipment-checkin-save",
            success: function (res) {
              if (res.status) {
                let location_id = $('#location_id').val();
                window.location.href = APP_URL + "/backend/rentals/" + location_id+'#Equipment';
              }
            },
            error: function (res) {
              ajax_error(res);
            },
        });
    });
    });
  </script>
  @endsection