@extends('layouts.settings')
  @section('title', 'Nomadic - Equipment Checkout')
  @section('content')
  <div class="banner"></div>
  <div class="container position-relative" data-aos="fade-up" style="top:50px;padding-bottom:30px;">
    <h2 class="mt-4 mb-5">{{__('Equipment Checkout Process')}}</h2>
    @if (session('error'))
    <div class="alert alert-danger p-2">{{session('error')}}</div>
    @elseif (session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif
  
    <div class="row mb-5 d-block">
      <div class="col-xl-12">
        <div class="row">
          <div class="col-xl-3">
            <label class="lblprofile">Equipment Details </label>
          </div>
          <div class="col-xl-6 mt-4">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                @if(!empty($data->photo))
                <img src="{{asset('storage/rental')}}/{{$data->photo}}" class="img-fluid w-100" style="border-radius: 5px;">
                @else
                <img src="{{asset('images/user-img.png')}}" class="img-fluid w-100" style="border-radius: 5px;">
                @endif
              </div>
            </div>
            <div class="row">
              <div class="col-md-3" style="font-weight:600;">Name</div>
              <div class="col-md-4">{{$data->name}}</div>
            </div>
            <div class="row mt-2">
              <div class="col-md-3" style="font-weight:600;">Serial Number</div>
              <div class="col-md-4">{{$data->serial_number}}</div>
            </div>
            <div class="row mt-2">
              <div class="col-md-3" style="font-weight:600;">Manual</div>
              <div class="col-md-4">
                @if(!empty($data->manual))
                <a href="{{asset('storage/manual')}}/{{$data->manual}}" target="_blank"> {{$data->manual}} </a>
                @endif
                @if(!empty($data->manual_link)) </br><a href="{{$data->manual_link}}">{{$data->manual_link}}</a> @endif
              </div>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-xl-3">
            <label class="lblprofile">Upload Photos</label>
          </div>
          <div class="col-xl-6 mt-4">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="hidden" id="lpid" value="{{$sessionId}}" readonly />
                <input type="hidden" id="booking_id" value="{{$booking_id}}" readonly />
                <input type="hidden" id="equipment_id" value="{{$equipment_id}}" readonly />
                <form action="{{url('fileupload')}}" method="post" enctype="multipart/form-data" id="equip_checkout" class="dropzone">
                  @csrf
                  <input type="hidden" id="location_id" name="location_id" value="{{$data->location_id}}" readonly>
                  <input type="hidden" id="type" name="type" value="equip_checkout" readonly>
                  <input type="hidden" name="image_type" value="photos" readonly>
                </form>
                <div id="checkoutimages" class="row mt-3">{!! $content !!}</div>
              </div>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-xl-3">
            <label class="lblprofile">Description</label>
          </div>
          <div class="col-xl-6 mt-4">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <textarea id="description" class="form-control txtarea mb-3" rows="8"></textarea>
              </div>
            </div>
          </div>
        </div>

        <div class="row mt-3">
          <div class="col-md-6 text-end">
            <input id="btn_savecheckout" type="button" class="btn btn-primary mb-2 mt-4" value="Checkout">
          </div>
        </div>
        
      </div>
    </div>
  </div>

  @endsection
  @section('footer_scripts')
  <link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
  <link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
  <script src="{{asset('js/dropzone.js')}}"></script>
  <script>
    // checkout photos
    Dropzone.autoDiscover = false;
    var myDropzone2 = new Dropzone("#equip_checkout",{ 
        maxFiles: 10,
        maxFilesize: 100,
        autoProcessQueue: true,
        uploadMultiple: false, 
        addRemoveLinks: true,
        acceptedFiles: ".jpeg,.jpg,.png",
    });
    myDropzone2.on("sending", function(file, xhr, formData) {
        
    });
    myDropzone2.on("uploadprogress", function (file, progress) {
        $('.progress-text').html(parseInt(progress)+'%');
    });
    myDropzone2.on("error", function (file, errorMessage) {
        $('.progress-text').html('0%').hide();
    });
    myDropzone2.on("success", function (file, response) {
        $('.progress-text').html('0%').hide();
        myDropzone2.removeAllFiles(true);
        if(response.status) {
            $('#checkoutimages').append(response.content);
        }
    });
  
    $(document).ready(function () {
      $(document).on("click", "#btn_savecheckout", function () {
        let booking_id = $("#booking_id").val();
        let equipment_id = $("#equipment_id").val();
        let description = $("#description").val();
        $.ajax({
            type: "POST",
            dataType: "json",
            data: {
              _token: _token,
              booking_id: booking_id,
              equipment_id: equipment_id,
              description:description
            },
            url: APP_URL + "/equipment-checkout-save",
            success: function (res) {
              if (res.status) {
                window.location.href = APP_URL + "/booking-confirmed/" + booking_id;
              }
            },
            error: function (res) {
              ajax_error(res);
            },
        });
    });
    });
  </script>
  @endsection