@extends('layouts.main')
@section('title', 'Nomadic-Events')
@section('content')

<div class="events-container">
  
  <section class="p-0 events-hero">
    <div class="row content">
      <div class="video-image">
        <img class="img-fluid w-100" src="{{asset('images/fe/event-sec-one.png')}}">
        <h1>{{__('Events')}}</h1>
      </div>
    </div>
  </section>

  <section class="events-list light-content">
    <div class="container" data-aos="fade-up">
      <div class="row">
        <div class="col-md-12">
          <div class="container">
            <div class="row">
              <div class="col-md-7 mx-auto">
                <h2>{{__('Discover events')}}</h2>
                <div class="clearfx"></div>
                <div class="btn-group gap-2">
                  <select class="btn-outline-secondary2 txtcustom" id="txt_location">
                    <option value="">Location</option>
                    @foreach($locations as $key=>$val)
                    <option value="{{$key}}" {{!empty(app('request')->filterLocation && app('request')->filterLocation==$key) ? 'selected' : ''}}>{{$val}}</option>
                    @endforeach
                  </select>
                  <input type="date" id="txt_date" class="btn-outline-secondary2 txtcustom" value="{{!empty(app('request')->filterDate) ? app('request')->filterDate : ''}}"/>
                </div>
                <div class="clearfix"></div>
              </div>
            </div>
          </div>
          <div class="col-md-7 mx-auto">
            <div class="container" data-aos="fade-up">
            @if($events->count() > 0)
              @foreach($events as $event)
              <div class="row mt-5">
                <div class="col-md-12">
                  <a href="{{url('view-event/'.$event->event_id)}}"><img src="{{asset('storage/location/events/thumb_'.$event->thumbnail)}}" class="img-thumbnail p-0 imgshadow"></a>
                  <div class="clearfix"></div>
                  <p class="mt-2 mb-2 d-block font13px">
                  {{date('l, d M',strtotime($event->event_date))}} AT {{date('h:i A',strtotime($event->event_time))}}
                  </p>
                  <h2>{{ucfirst($event->event_title)}}</h2>

                  @if($event->event_type=='online')
                  <p class="mt-2 mb-2 d-block font13px" style="text-transform: uppercase;">{{$event->event_type}}</p>
                  @endif
                  @if($event->event_type=='location' && $event->address!='')
                  <p class="mt-2 mb-2 d-block font13px" style="text-transform: uppercase;">{{$event->address}}</p>
                  @endif
                  <div class="small">
                    <span>{{$event->interested_count}}</span> interested - <span>{{$event->going_count}}</span> going
                  </div>
                  <div class="row mt-3">
                    <div class="col-md-5 d-grid">
                      <button type="button" class="btn btn-primary section-btn" @if(Auth::guest()) disabled @elseif(isset($event->interested[0]->user_id)) disabled @else onclick="event_action(this,{{$event->event_id}},'interested')" @endif> Interested <i class="bi bi-hand-thumbs-up"></i></button>
                    </div>
                    @if($event->public_private=='public')
                    <div class="col-md-5 d-grid">
                      <button type="button" class="btn btn-primary section-btn goingevent" data-event="{{$event->event_id}}" @if(Auth::guest()) disabled @elseif(isset($event->going[0]->user_id)) disabled @endif><span>@if(!empty($event->ticket_price)) {{$event->ticket_price}} Points @endif</span></br> Going <i class="bi bi-arrow-right"></i></button>
                    </div>
                    @endif
                    <div class="col-md-2 d-grid">
                      <button type="button" class="btn section-btn" onclick="share({{$event->event_id}})"><i class="bi bi-share"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              @endforeach
            @endif
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

</div>

@endsection
@section('footer_scripts')
<script>
$(document).ready(function () {
  // events filters
  $(document).on('change','#txt_date, #txt_location',function(){
    events_filter();
  });
});
function events_filter(){
  let txt_date = $('#txt_date').val();
  let txt_location = $('#txt_location').val();
  let url_filter = [];
  if(txt_date!=""){
    url_filter.push('filterDate='+txt_date);
  }
  if(txt_location!=""){
    url_filter.push('filterLocation='+txt_location);
  }
  if(url_filter.length>0){
    let filter = url_filter.join('&');
    window.location.href = APP_URL+'/events?'+filter;
  }else{
    window.location.href = APP_URL+'/events';
  }
}
</script>
@endsection