@extends('layouts.guest')
@section('title', 'Nomadic Studios')
@section('content')
<div class="container" align="center">
  <div class="row w-75">
    <div class="card boxshadow">
      <div class="card-body pt-3">
        <div class="row">
          <div class="col-md-3 mb-2 position-relative">
            <div class="imgbox1">
              @if(!empty($data->profile_pic))
              <img src="{{asset('storage/profile-pic')}}/{{$data->profile_pic}}" height="150">
              @else
              <img src="{{asset('images/user-img.png')}}" height="150">
              @endif
            </div>
          </div>
          <div class="col-md-9 mb-2 position-relative overflow-auto">
            <table class="table table-borderless">
              <thead>
                <tr>
                  <td>Name</td>
                  <td>Email</td>
                  <td>Invitation Type</td>
                  <td>Invited By</td> 
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th>{{ucfirst($data->fname)}} {{ucfirst($data->lname)}}</th>
                  <th>{{$data->email}}</th>
                  <th>{{ucfirst($data->invitation_type)}}</th>
                  <th>{{$data->host->fname}} {{$data->host->lname}}</th>
                </tr>
                <tr>
                  <td>Status</td>
                  <td>Event Name</td>  
                  <td>Date</td>
                  <td>Price</td>
                </tr>
                <tr>
                  <th>
                    @if (Auth::guest())
                      <a class="btn btn-dark w-100 mb-2" href="{{url('login')}}">Login</a>
                    @else
                      @if($data->status==0)
                      <input type="button" class="btn btn-dark goingevent w-100 mb-2" data-event="{{$event->event_id}}" data-guest="{{$data->id}}" value="Payment">
                      @elseif($data->status==1)
                      <b>Checked In</b>
                      @elseif($data->status==2)
                      <b>Cancelled</b>
                      @elseif($data->status==3)
                      <b>Paid</b>
                      @endif
                    @endif
                  </th>
                  <th>{{$event->event_title}}</th>
                  <th>{{($event->event_date)}} {{($event->event_time)}}</th>
                  <th>{{$event->ticket_price}} Points</th>
                </tr>
              </tbody>
            </table>
          </div>
        </div>        
      </div>
    </div>
  </div>
</div>
<!-- <div class="modal fade" id="otp_modal" style="display:none;z-index:10000;"></div> -->
<script>
  $(document).ready(function(){
    $(document).on('click', '.invaction', function(){ 
      let upcoming_id = $(this).data('guest');
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, upcoming_id:upcoming_id, status:1},
        url: APP_URL+"/invite-action",
        success: function(res) {
          if(res.status){
            window.location.reload();
          }else{
            $('#general_modal .modal-title').html('Recharge your wallet');
            $('#general_modal .modal-body').html(res.content);
            $('#general_modal').modal('show');
          }
        },
        error: function(res) {                    
          //ajax_error(res);
        }
      });
    });
  });
</script>
@endsection