@extends('layouts.main')
@section('title', 'Nomadic Studios | Invite your guest')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4 mb-4">{{__('Invite your guest')}} @if($type && $id) - {{ucfirst($type)}} ({{$id}}) @endif</h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
             @if(session('success'))
            <div class="alert alert-success p-2">{{session('success')}}</div>
            @endif
            <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
            <form action="{{ route('invite.guest.process') }}" method="POST" id="invite" class="w-100">
                @csrf
                <input type="hidden" name="num" value="{{$id}}" readonly>
                <input type="hidden" name="type" value="{{$type}}" readonly>
                <div class="form-container">
                    <div class="form-group mb-2">Select Location</div>
                    <div class="form-group mb-2 position-relative">
                        <select class="form-control shadow-none" @if(isset($loc)) disabled @endif name="location_id" id="txt_location">
                            <option value="">Location</option>
                            @foreach($locations as $key=>$val)
                            <option value="{{$key}}" @if(isset($loc) && $loc==$key) selected @endif>{{$val}}</option>
                            @endforeach
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    @if($type=='event')
                    <div class="form-group mb-2">Select Event</div>
                    <div class="form-group mb-2 position-relative">
                        <select class="form-control shadow-none" name="event_id" id="txt_event"S>
                            <option value="">Event</option>
                            @foreach($event_list as $ev)
                            <option value="{{$ev->event_id}}" @if($id==$ev->event_id) selected @endif>{{$ev->event_title}}</option>
                            @endforeach
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    @endif
                    <div class="form-group mb-2">Details of your guest</div>
                    <div class="form-group mb-2">
                        <input type="text" id="fname" name="fname" class="form-control shadow-none" placeholder="{{__('First Name')}}" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="text" id="lname" name="lname" class="form-control shadow-none" placeholder="{{__('Last Name')}}" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="email" id="email" name="email" class="form-control shadow-none" placeholder="{{__('Email')}}" />
                    </div>

                    <div class="form-group mb-2 @if($type=='event') d-none @endif">Select Date and Time</div>
                    <div class="form-group mb-2 @if($type=='event') d-none @endif">
                        <input type="date" id="txt_date" name="invitation_date" class="form-control shadow-none" value="{{(isset($start_date)) ? $start_date : ''}}" @if(isset($start_date)) disabled @endif/>
                    </div>
                    <div class="form-group mb-2 @if($type=='event') d-none @endif">
                        <input type="time" name="invitation_time" value="{{(isset($start_time)) ? $start_time : ''}}" class="form-control shadow-none" @if(isset($start_time)) disabled @endif/>
                    </div>
                    
                    @if($type=='event')
                    <div class="form-group mb-2">
                        <input type="tel" placeholder="{{__('Mobile Number')}}" id="telephone" class="form-control shadow-none" maxlength="14"/>
                        <span id="msg" class="error"></span>
                        <input type="hidden" id="mobile_number" name="mobile_number"/>
                    </div>

                    <div class="form-group mb-2">Event Price - {{$ticket_price_local}} ({{session()->get('user_currency')}})</div>
                    <div class="form-group input-group mb-2">
                        <input type="number" id="comp" name="comp" class="form-control shadow-none" placeholder="Event price in points" value="{{$ticket_price}}" />
                        <span class="input-group-text" id="basic-addon2">Points</span>
                    </div>
                    @endif

                    <div class="btnconter mt-3 mb-4">
                        <input type="submit" class="btn btn-primary" name="submit" value="{{__('Invite Guest')}}" />
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<link rel="stylesheet" href="{{asset('css/intlTelInput.css')}}">
<script src="{{asset('js/intlTelInput.js')}}"></script> 
<script>
    var errorMap = ["{{__('Invalid number')}}", "{{__('Invalid country code')}}", "{{__('Too short')}}", "{{__('Too long')}}"];
    var input = document.querySelector("#telephone");
    var msg = document.querySelector("#msg");
    var intl = window.intlTelInput(input, {
        autoPlaceholder: false,
        separateDialCode: true,
        placeholderNumberType: "MOBILE",
        utilsScript: "{{asset('js/utils.js')}}"
    });
    // Validate on blur event
    input.addEventListener('keyup', function() {
        if(input.value.trim()){
            if(intl.isValidNumber()){
                input.classList.remove("error");
                msg.classList.add("hide");
                //msg.hide();
            }else{
                input.classList.add("error");
                var errorCode = intl.getValidationError();
                msg.innerHTML = errorMap[errorCode];
                msg.classList.remove("hide");
                //msg.show();
            }
        }
        let full_number = intl.getNumber();
        $('#mobile_number').val(full_number);
    });
    $(document).on('change','#txt_event',function(){
        let val = $(this).val();
        if(val!=""){
            window.location.href = APP_URL+'/invite-guest/event/'+val;
        }
    });
    
</script>
@endsection
