@extends('layouts.main')
@section('title', 'Nomadic Studios | Invited guests')
@section('content')
<div class="banner">
    <div class="img-text img-margin">{{__('Join global creatives')}}</div>
    <img class="img-fluid w-100" src="{{asset('images/banner1.png')}}">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4">{{__('Your invited guests')}}</h2>
    <div class="row mb-5 d-block"  align="center">
      <div class="col-md-4">
      @if(session('success'))
      <div class="alert alert-success p-2">{{session('success')}}</div>
      @endif
      @if($data->count() > 0)
      @foreach($data as $dt)    
      <div class="card thinborder invitedcard pointer" data-id="{{$dt->id}}" style="width:450px;">
        <div class="card-body pt-3">
          <div class="row">
            <div class="col-md-3 imagecard">
              @if($dt->profile_pic)
              <img src="{{asset('storage/profile-pic')}}/{{$dt->profile_pic}}"  class="img-fluid">
              @else
              <img src="{{asset('images/user-img.png')}}" class="img-fluid">
              @endif
            </div>
            <div class="col-md-9 text-start">
              <div class="row">
                <div class="col-md-12">
                  <label class="small text-muted">Date</label>
                  <div class="clearboth"></div>
                  <span class="timecard">{{($dt->invitation_date)}} {{($dt->invitation_time)}}</span>  
                </div>
              </div>
              <div class="row">
                <div class="col-md-4">
                  <label class="small text-muted">Location</label>
                  <div class="clearboth"></div>
                  <span class="timeloc">{{ucfirst($dt->location->location)}}</span>
                </div>
                <div class="col-md-8">
                  <label class="small text-muted">Guest</label>
                  <div class="clearboth"></div>
                  <span class="timename">{{ucfirst($dt->fname)}} {{ucfirst($dt->lname)}}</span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      @endforeach
      <div class="row col-md-12 mt-5">
          <div class="foot-paging">
          {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
          </div>
      </div>
      @else
      <h6>You have not invited any guest.</h6>  
      @endif
      </div>
    </div>
</div>
<script>
  $(document).ready(function(){
    $(document).on('click', '.invaction', function(){ 
      let upcoming_id = $(this).data('guest');
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, upcoming_id:upcoming_id, status:1},
        url: APP_URL+"/invite-action",
        success: function(res) {
          if(res.status){
            window.location.reload();
          }else{
            $('#general_modal .modal-title').html('Recharge your wallet');
            $('#general_modal .modal-body').html(res.content);
            $('#general_modal').modal('show');
          }
        },
        error: function(res) {                    
          //ajax_error(res);
        }
      });
    });
  });
  </script>
@endsection