@extends('layouts.main')
@section('title', 'Nomadic-Locations')
@section('content')
<div class="places-hero light-content">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-6 col-xxl-6">
        <h1>{!! __('locations.heading1') !!}</h1>
      </div>
      <div class="col-md-12 col-xl-6 col-xxl-6">
        <p>{!! __('locations.heading_desc1') !!}</p>
      </div>
    </div>
  </div>
</div>

<div class="places-break-bg"></div>

<section class="section places-find-inspiration-section">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <h2>{!! __('locations.heading2') !!}</h2>
        <p>{!! __('locations.heading_desc2') !!}</p>
      </div>
    </div>
  </div>
</section>

<section class="section light-content places-locations-section">
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <h2>{{__('Locations')}}</h2>
      </div>
    </div>
    <div class="row places-locations-section__locations">
      @foreach($locations as $loc)
      @if($loc->location=='Global') @continue @endif
      <div class="col-md-12 col-xl-6 places-location-container">
        <div class="places-location">
          <div class="places-location-image">
            @if(isset($loc->landing_page->banner_picture))
            <img class="@if($loc->coming_soon==1) opacity-50 @endif" src="{{asset('storage/location/'.$loc->landing_page->banner_picture)}}" />
            @endif
          </div>
          <div class="places-location-content">
            
            <a @if($loc->coming_soon!=1) href="{{url('locations/'.$loc->slug)}}" @else href="#" @endif class="btn section-btn text-decoration-none">{{__('Explore')}} {{$loc->location}} {{__('Studios')}}</a>
            
          </div>
        </div>
      </div>
      @endforeach
    </div>
  </div>
</section>
@endsection