@extends('layouts.main')
@section('title', 'News')
@section('content')
<div class="news-details-container light-content">
  <section class="p-0">
    <div class="row content">
      <div class="video-image">
        <img class="img-fluid w-100" src="{{asset('storage/location/news/'.$news->banner)}}">
      </div>
    </div>

    <div class="container" data-aos="fade-up">
      <div class="row">
        <div class="col-md-12">
          <div class="col-md-7 mx-auto">
            <div class="container mt-4" data-aos="fade-up">
              <div class="row">
                <div class="col-md-12">
                  <div class="mt-2 mb-2 d-block text-success">{{$news->tags}}</div>
                  <h1>{{ucfirst($news->name)}}</h1>
                  <div class="d-inline">
                    @if($news->createdBy->profile_pic)
                    <img src="{{asset('storage/profile-pic/'.$news->createdBy->profile_pic)}}" alt="Profile" class="rounded-circle height35">
                    @else
                    <img src="{{asset('images/user-img.png')}}" alt="Profile" class="rounded-circle height35">
                    @endif
                  </div>
                  <div class="d-inline">
                    <span class="font13px" style="font-weight:100">{{ucfirst($news->createdBy->fname)}} {{ucfirst($news->createdBy->lname)}}</span>
                    <div class="font12px" style="margin-top:-15px;margin-left:40px">
                    {{date('d l Y',strtotime($news->created_at))}}
                    </div>
                  </div>
                </div>
                <div class="col-md-12 mt-4">
                  <div class="heading3 dark">{{$news->heading_intro}}</div>
                  <div class="mb-2">{!! html_entity_decode($news->para_intro) !!}</div>
                </div>
                <div class="col-md-12 mt-4">
                  <div class="heading3 dark">{{$news->heading_elaboration}}</div>
                  <div class="mb-2">{!! html_entity_decode($news->para_elaboration) !!}</div>
                </div>
                <div class="col-md-12 mt-4">
                  @if($news->conclusion_picture)
                  <img src="{{asset('storage/location/news/'.$news->conclusion_picture)}}" alt="Profile" class="img-thumbnail p-0">
                  @endif
                  @if($news->heading_conclusion)
                  <div class="mt-3 keyinfobg p-3">
                    <div class="heading3 dark">{{$news->heading_conclusion}}</div>
                    <div class="mb-2">{!! html_entity_decode($news->para_conclusion) !!}</div>
                  </div>
                  @endif
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="p-0">
    <div class="container" data-aos="fade-up">
      @include('frontend.news.related-news')
    </div>
  </section>

</div>
@endsection