@extends('layouts.main')
@section('title', 'Nomadic-Our Partners')
@section('content')
<div class="ourpartners-container light-content">
  <section class="p-0">
    <div class="row content">
      <div class="video-image">
        <div class="facilities-and-resources mt160">
          <div style="color:#ccc">
          {!! __('partners.heading1') !!} <br>
            <p style="color:#fff">{!! __('partners.heading2') !!}</p>
          </div>
        </div>
        <img class="img-fluid w-100 hero" src="{{asset('images/our-partners/banner.png')}}">
      </div>
    </div>
  </section>

  <div class="container">
    <div class="row">
      <div class="heading5 text-center mb-1" style="display:block">
        {{__('Partners and Providers')}}
      </div>
    </div>
  </div>

  <div class="swiper swiper2" style="overflow-x:hidden">
    <!-- First Slide -->
    <div class="swiper-wrapper">
      @foreach($partners as $partner)
      <div class="swiper-slide">
        <div class="card">
          <img src="{{asset($partner->image_path)}}" class="card-img-top" alt="Image 1">
        </div>
      </div>
      @endforeach
    </div>
    <button class="carousel-control-prev carousel-control-prev2" type="button">
      <span class="carousel-control-prev-icon" aria-hidden="true" style="color:#c58b63;font-size:50px"></span>
      <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next carousel-control-next2" type="button">
      <span class="carousel-control-next-icon" aria-hidden="true" style="color:#c58b63;font-size:50px"></span>
      <span class="visually-hidden">Next</span>
    </button>
  </div>

  <div class="container">
    <div class="row">
      <div class="heading5 text-center mb-1" style="display:block">
        {{__('Nomadic Satellites')}}
      </div>
    </div>
  </div>

  <div class="swiper">
    <!-- First Slide -->
    <div class="swiper-wrapper">
      @foreach($locations as $loc)
      @if(strtolower($loc->location)=='global') @continue @endif
      <div class="swiper-slide">
        <div class="card">
          <div class="col-md-12 col-xl-12 places-location-container">
            <div class="places-location p-3">
              <div class="places-location-image">
                @if(isset($loc->landing_page->banner_picture))
                <img class="@if($loc->coming_soon==1) opacity-50 @endif" src="{{asset('storage/location/'.$loc->landing_page->banner_picture)}}" />
                @else
                <img src="bali.5ccf555e.png" alt="Bali">
                @endif
              </div>
              <div class="places-location-content">
                @if($loc->coming_soon==1)
                <a href="#" class="btn section-btn text-decoration-none">Explore {{$loc->location}} Studios</a>
                @else
                <a href="{{url('locations/'.$loc->slug)}}" class="btn section-btn text-decoration-none">Explore {{$loc->location}} Studios</a>
                @endif
              </div>
            </div>
          </div>
        </div>
      </div>
      @endforeach
    </div>
    <button class="carousel-control-prev" type="button">
      <span class="carousel-control-prev-icon" aria-hidden="true" style="color:#c58b63;font-size:50px"></span>
      <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next" type="button">
      <span class="carousel-control-next-icon" aria-hidden="true" style="color:#c58b63;font-size:50px"></span>
      <span class="visually-hidden">Next</span>
    </button>
</div>
<script>
document.addEventListener("DOMContentLoaded",()=>{new Swiper(".swiper",{slidesPerView:3,loop:!0,spaceBetween:10,autoplay:{delay:3e3,disableOnInteraction:!1},navigation:{nextEl:".carousel-control-next",prevEl:".carousel-control-prev"},breakpoints:{1024:{slidesPerView:3},380:{slidesPerView:1}}}),new Swiper(".swiper2",{slidesPerView:4,loop:!0,spaceBetween:120,autoplay:{delay:3e3,disableOnInteraction:!1},navigation:{nextEl:".carousel-control-next2",prevEl:".carousel-control-prev2"},breakpoints:{1024:{slidesPerView:4},380:{slidesPerView:1}}})})
</script>
@endsection