@extends('layouts.main')
@section('title', 'Profile')
@section('content')

<div class="section dark-content people-individual-hero-section">
  <div class="row content pt-5 pb-5 ps-4 pe-4">
    <div class="col-md-5">
      @if($resource->profile_pic)
      <img class="img-fluid w-100 imgshadow" src="{{url('storage/profile-pic/'.$resource->profile_pic)}}" />
      @else
      <img class="img-fluid w-100 imgshadow" src="{{url('images/user-img.png')}}" />
      @endif
    </div>
    <div class="col-md-7 details">
      <h1>{{$resource->fname}} {{$resource->lname}}</h1>
      @if($specialist)
        <div class="row">
          @foreach($specialist as $sp)
          <div class="col-md-4 mt-3">
            <h2>{{$sp->location}}</h2>
            <h3>{{$sp->name}}</h3>
          </div>
          @endforeach
        </div>
      @endif
      <a @if (Auth::guest()) href="{{url('login')}}" @else href="{{url('choose-your-preference/resource')}}" @endif class="btn section-btn text-decoration-none">{{__('Book Now')}}</a>
    </div>
  </div>
</div>

<section class="section people-individual-bio-section light-content">
  <div class="container" data-aos="fade-up" style="min-height:200px">
    <div class="row">
      <div class="col-md-4">
        <h2>{{__('About Me')}}</h2>
        <div class="clearfix"></div>
        <h2>{{__('Bio')}}</h2>
      </div>
      <div class="col-md-8">
        <p>{{$resource->description}}</p>
        <div class="languages">
          <h3>Language Spoken</h3>
          <h3>{{$resource->languages}}</h3>
        </div>
      </div>
    </div>
  </div>
</section>

@if($resource->profile_link || $resource->instagram_link || $resource->facebook_link || $resource->twitter_link || $resource->sm_link)
<section class="section people-individual-links-section dark-content">
  <div class="container" data-aos="fade-up" style="min-height:200px">
    <div class="row">
      <div class="col-md-4">
        <h2>{{__('Check My')}}</h2>
        <div class="clearfix"></div>
        <h2>{{__('Links')}}</h2>
      </div>
      <div class="col-md-8">
        @if($resource->profile_link)
        <div>
          <a href="{{$resource->profile_link}}">Portfolio <img src="{{asset('images/arrow-up-right.62414968.svg')}}" class="arrow"></a>
        </div>
        @endif
        @if($resource->instagram_link)
        <div>
          <a href="{{$resource->instagram_link}}">Instagram <img src="{{asset('images/arrow-up-right.62414968.svg')}}" class="arrow"></a>
        </div>
        @endif
        @if($resource->facebook_link)
        <div>
          <a href="{{$resource->facebook_link}}">Facebook <img src="{{asset('images/arrow-up-right.62414968.svg')}}" class="arrow"></a>
        </div>
        @endif
        @if($resource->twitter_link)
        <div>
          <a href="{{$resource->twitter_link}}">Twitter <img src="{{asset('images/arrow-up-right.62414968.svg')}}" class="arrow"></a>
        </div>
        @endif
        @if($resource->sm_link)
        <div>
          <a href="{{$resource->sm_link}}">SM Link <img src="{{asset('images/arrow-up-right.62414968.svg')}}" class="arrow"></a>
        </div>
        @endif
      </div>
    </div>
  </div>
</section>
@endif
<section class="section people-individual-book-section light-content">
  <div class="container" data-aos="fade-up" style="min-height:200px">
    <div class="row">
      <div class="col-md-12 col-xl-4"></div>
      <div class="col-md-12 col-xl-8">
        <div class="text-center mt-3 mb-3">
          <a @if (Auth::guest()) href="{{url('login')}}" @else href="{{url('choose-your-preference/resource')}}" @endif class="btn section-btn text-decoration-none">{{__('Book Now')}}</a>
          <div class="clearfix"></div>
          <img src="{{asset('images/drums.c38a2f2c.svg')}}" class="img-fluid">
        </div>
      </div>
    </div>
  </div>
</section>
@endsection