@extends('layouts.main')
@section('title', 'Nomadic-People')
@section('content')
<div class="people-hero-section">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4">
        <h1>{!! __('people.heading') !!}</h1>
        <p>{!! __('people.desc') !!}</p>
      </div>
    </div>
  </div>
</div>

<section class="section people-list-section light-content">
  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-12 col-lg-3">
        @if($crews)
          <h5>{{__('Specialist')}}</h5>
          @foreach($crews as $crew)
          <div class="clearfix"></div>
          <h6 class="txtgray">{{$crew->name}}</h6>
          @endforeach
        @endif
        @if($locations)
          <h5 class="mt-3">Locations</h5>
          @foreach($locations as $loc)
          <div class="clearfix"></div>
          <h6 class="txtgray">{{$loc->location}}</h6>
          @endforeach
        @endif
      </div>
      @if($resources)
        <div class="col-md-12 col-lg-9 people-list">
          <div class="row">
            @foreach($resources as $res)
            <div class="col-md-4">
              <div class="imgbox">
                <a href="{{url('crew-profile/'.$res->uuid)}}"><img src="{{url('storage/profile-pic/'.$res->profile_pic)}}" class="imgfluidlogged imgshadow" /></a>
              </div>
              <div class="clearfix"></div>
              <h6 class="mt-2">{{$res->fname}} {{$res->lname}}</h6>
              <div class="clearfix"></div>
              <div class="d-inline">
                <p class="float-start">{{$res->name}}</p>
                <!-- <h6 class="float-end fontsize9rem">Mex</h6> -->
              </div>
            </div>
            @endforeach
          </div>
        </div>
      @endif
    </div>
    
  </div>
</section>

@endsection