@extends('layouts.main')
@section('title', 'Nomadic-Services')
@section('content')
<div class="services-hero-section">
  <div class="row content">
    <div class="video-image">
      <div class="facilities-and-resources">
        <h1>{!!__('services.heading')!!}</h1>
      </div>
      <img class="img-fluid w-100" src="{{asset('images/fe/services-sec-one.png')}}">
    </div>
  </div>
</div>

<section class="section services-details-section light-content">
  <div class="container" data-aos="fade-up" style="min-height:200px">
    <div class="row">
      <div class="col-md-7 mx-auto">
        <div class="content1 heading5">
          <p>{!!__('services.desc')!!}</p>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section services-amplify-section dark-content">
  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-6">
        <img class="img-fluid w-100 imgshadow" src="{{asset('images/fe/services-sec-two.png')}}">
      </div>
      <div class="col-md-6 details">
        <h2>{!!__('services.amplify')!!}</h2>
        <p>{!!__('services.amplify_desc')!!}</p>
        <div>
          <a href="{{url('services/social-media-services')}}"><button type="button" class="btn section-btn text-decoration-none">
          {!!__('Learn More About Social Media Services')!!}
            </button></a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section services-protect-section light-content">
  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-6 details">
        <h2>{!!__('services.protect')!!}</h2>
        <p>{!!__('services.protect_desc')!!}</p>
        <div>
          <a href="{{url('services/legal-services')}}"><button type="button" class="btn section-btn text-decoration-none">
          {!!__('Explore Legal Services')!!}
            </button></a>
        </div>
      </div>
      <div class="col-md-6">
        <img class="img-fluid w-100 imgshadow" src="{{asset('images/fe/services-sec-three.png')}}">
      </div>
    </div>
  </div>
</section>

<section class="section services-finances-section dark-content">
  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-6">
        <img class="img-fluid w-100 imgshadow" src="{{asset('images/fe/services-sec-four.png')}}">
      </div>
      <div class="col-md-6 details">
        <h2>{!!__('services.master')!!}</h2>
        <p>{!!__('services.master_desc')!!}</p>
        <div>
          <a href="{{url('services/accounting-tax-services')}}"><button type="button" class="btn section-btn text-decoration-none">
          {!!__('Discover Financial Services')!!}
            </button></a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section services-monetize-section light-content">
  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-6 details">
        <h2>{!!__('services.monetize')!!}</h2>
        <p>{!!__('services.monetize_desc')!!}</p>
        <div>
          <a href="{{url('services/online-services')}}"><button type="button" class="btn section-btn text-decoration-none">
          {!!__('Explore Online Services')!!}
            </button></a>
        </div>
      </div>
      <div class="col-md-6">
        <img class="img-fluid w-100 imgshadow" src="{{asset('images/fe/services-sec-five.png')}}">
      </div>
    </div>
  </div>
</section>
@endsection