@extends('layouts.main')
@section('title', 'Nomadic - '.$loc->location.' '.ucfirst($stslug).' Studio')
@section('content')
<div class="section location-individual-hero-section container light-content">
  <div class="row content fade-up">
    <div class="col-md-12 col-xl-7">
      <h1>{{__('Welcome to')}} {{$loc->location}},<br>{{__('Your Creative Hub')}}</h1>
      {!! html_entity_decode($loc->landing_page->description) !!}
    </div>
  </div>
</div>

<section class="location-individual-hero-bg"></section>

<section class="section location-individual-studios-section light-content">
  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-12 col-xl-4"></div>
      <div class="col-md-12 col-xl-8">
        <h2>
          {{__('Studios to Create')}}<br>
          {{__('in')}} {{$loc->location}} - UBUD
        </h2>
      </div>
    </div>
    <div class="row">
      @if($studios)
      @foreach($studios as $st)
      @if(isset($st->studio->id))
      <div class="col-md-3 mb-4 overflow-hidden">
        <img class="img-fluid w-100 imgshadow" src="{{url('storage/location/thumb_'.$st->banner_picture)}}">
        <div class="heading5 float-start mt-2">
          <a href="{{url('studio/'.$st->studio->studio_slug)}}">{{$st->studio->name}}
            <img src="{{asset('images/arrow-up-right.62414968.svg')}}" class="arrow"></a>
        </div>
      </div>
      @endif
      @endforeach
      @endif
    </div>
  </div>
</section>

<section class="section location-individual-stats-section black-content">
  <div class="container">
    <div class="row">
      <h2>{{__('What Makes')}} {{$loc->location}} {{__('Special')}}</h2>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-2"></div>
      <div class="col-md-12 col-xl-3 mb-4 overflow-hidden">
        <h3>2</h3>
        <p>{{__('studio spaces available')}}</p>
      </div>
      <div class="col-md-12 col-xl-3 mb-4 overflow-hidden">
        <h3>13</h3>
        <p>{!! __('collab_monthly') !!}</p>
      </div>
      <div class="col-md-12 col-xl-3 mb-4 overflow-hidden">
        <h3>5</h3>
        <p>{{__('minutes from the city center')}}</p>
      </div>
    </div>
  </div>
</section>

<section class="section location-individual-staff-section light-content">
<div class="container">
    <div class="row">
      <h2>{{__('Meet the Creatives of')}} {{$loc->location}}</h2>
    </div>
  </div>
  @include('frontend.crews1')
</section>

<section class="section location-individual-details-section dark-content">
  <div class="container" data-aos="fade-up">
    <div class="row">
      <div class="col-md-12">
        <h2>{{__('Plan Your Visit')}}</h2>
      </div>
    </div>
    <div class="row">
      <div class="col-md-6 overflow-hidden">
        <img class="img-fluid w-100" src="{{url('images/loc-detail.png')}}">
      </div>
      <div class="col-md-6 light-content" style="padding:50px 80px">
        <h3>{{__('Key information')}}</h3>
        <div class="org-line1 mb-4"></div>
        <div class="clearfix"></div>
        <small>{{__('ADDRESS')}}</small>
        <address>{{$loc->landing_page->address}}</address>
        <div class="clearfix"></div>
        <small>{{__('OPENING HOURS')}}</small>
        <address>{{$loc->landing_page->opening_hours}}</address>
        <div class="clearfix"></div>
        <small>{{__('CONTACT')}}</small>
        <address>{{__('Phone')}}: {{$loc->landing_page->phone}}<br/>{{__('Email')}}: {{$loc->landing_page->email}}</address>
        <div class="clearfix"></div>
        <small>{{__('GETTING HERE')}}</small>
        <address>{{$loc->landing_page->how_to_get_there}}</address>
      </div>
    </div>
  </div>

  <div class="col-md-12 map">
    <div class="mapouter">
      <div class="gmap_canvas">
        <iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=1324&amp;height=400&amp;hl=en&amp;q={{$loc->location}}&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
      </div>
      <style>.mapouter{text-align:right;width:100%;height:400px;position:relative}.gmap_canvas{width:100%;height:400px;overflow:hidden;background:0 0!important}.gmap_iframe{height:400px!important}</style>
    </div>
  </div>


  <div class="row mt-5">
    <div class="col-md-12 text-center">
    <a @if (Auth::guest()) href="{{url('login')}}" @else href="{{url('home')}}" @endif>
        <div class="heading4">
          {{__('Book Now')}}
          <svg class="_252" width="24" height="25" viewbox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z" fill="#111111"></path>
          </svg>
        </div>
      </a>
    </div>
  </div>
</section>
@endsection
@section('footer_scripts')
<link href="{{asset('css/thumbnail-slider.css')}}" rel="stylesheet">
<script src="{{asset('js/thumbnail-slider.js')}}"></script>
@endsection