@extends('layouts.main')
@section('title', 'Nomadic - Fine Art Studios')
@section('content')

<div class="studios-hero studios-hero--art">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-12 col-xxl-12">
        <h1>{!! __('studios.fineart.heading') !!}</h1>
      </div>
    </div>
  </div>
</div>

<section class="section studios-individual-section dark-content">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-8 col-xxl-8">
      <h2>{!! __('studios.fineart.inspire_creative') !!}</h2>
      <p>{!! __('studios.fineart.inspire_creative_desc') !!}</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-7 col-xxl-7">
        <img src="{{asset('images/studio-art-1.a2a4fad0.png')}}">
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-5 col-xxl-5"></div>
      <div class="col-md-12 col-xl-7 col-xxl-7">
        <img src="{{asset('images/studio-art-2.37ba57c6.png')}}">
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-7 col-xxl-7">
        <img src="{{asset('images/studio-art-3.7a3003fb.png')}}">
      </div>
    </div>

    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-8 col-xxl-8">
      <h2>{!! __('studios.fineart.craft') !!}</h2>
      <p>{!! __('studios.fineart.craft_desc') !!}</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-8 col-xxl-8">
        <img src="{{asset('images/studio-art-wide.34c94b99.png')}}">
      </div>
    </div>

    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-8 col-xxl-8">
      <h2>{!! __('studios.fineart.collab_connect') !!}</h2>
      <p>{!! __('studios.fineart.collab_connect_desc') !!}</p>
      </div>
    </div>

    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-2 col-xxl-2">
        <img src="{{asset('images/studio-art-square-1.a810d664.png')}}">
      </div>
      <div class="col-md-12 col-xl-1 col-xxl-1"></div>
      <div class="col-md-12 col-xl-2 col-xxl-2">
        <img src="{{asset('images/studio-art-square-2.906dca96.png')}}">
        <div class="row">
          <a @if (Auth::guest()) href="{{url('login')}}" @else href="{{url('choose-your-preference/studio')}}" @endif class="btn section-btn text-decoration-none">{{__('Book Now')}}</a>
        </div>
      </div>
      <div class="col-md-12 col-xl-1 col-xxl-1"></div>
      <div class="col-md-12 col-xl-2 col-xxl-2">
        <img src="{{asset('images/studio-art-square-3.365eaf51.png')}}">
      </div>
    </div>
  </div>
</section>

@include('frontend.locations')

@include('frontend.crews')

@endsection