@extends('layouts.main')
@section('title', 'Nomadic - Maker Space Studios')
@section('content')

<div class="studios-hero studios-hero--maker">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-12 col-xxl-12">
        <h1>{!! __('studios.maker.heading') !!}</h1>
      </div>
    </div>
  </div>
</div>

<section class="section studios-individual-section dark-content">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-8 col-xxl-8">
      <h2>{!! __('studios.maker.bigger') !!}</h2>
      <p>{!! __('studios.maker.bigger_desc') !!}</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-7 col-xxl-7">
        <img src="{{asset('images/studio-maker-1.7ab4864f.png')}}">
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-5 col-xxl-5"></div>
      <div class="col-md-12 col-xl-7 col-xxl-7">
        <img src="{{asset('images/studio-maker-2.58f0e99e.png')}}">
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-7 col-xxl-7">
        <img src="{{asset('images/studio-maker-3.0d8db48e.png')}}">
      </div>
    </div>

    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-8 col-xxl-8">
      <h2>{!! __('studios.maker.maker_tool') !!}</h2>
      <p>{!! __('studios.maker.maker_tool_desc') !!}</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-8 col-xxl-8">
        <img src="{{asset('images/studio-maker-wide.cda61ddf.png')}}">
      </div>
    </div>

    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-8 col-xxl-8">
      <h2>{!! __('studios.maker.fellow') !!}</h2>
      <p>{!! __('studios.maker.fellow_desc') !!}</p>
      </div>
    </div>

    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4"></div>
      <div class="col-md-12 col-xl-2 col-xxl-2">
        <img src="{{asset('images/studio-maker-square-1.860268bf.png')}}">
      </div>
      <div class="col-md-12 col-xl-1 col-xxl-1">
      </div>
      <div class="col-md-12 col-xl-2 col-xxl-2">
        <img src="{{asset('images/studio-maker-square-2.07dc70ba.png')}}">
        <div class="row">
        <a @if (Auth::guest()) href="{{url('login')}}" @else href="{{url('choose-your-preference/studio')}}" @endif class="btn section-btn text-decoration-none">{{__('Book Now')}}</a>
        </div>
      </div>
      <div class="col-md-12 col-xl-1 col-xxl-1">
      </div>
      <div class="col-md-12 col-xl-2 col-xxl-2">
        <img src="{{asset('images/studio-maker-square-3.63bfd754.png')}}">
      </div>
    </div>
  </div>
</section>

@include('frontend.locations')

@include('frontend.crews')

@endsection