@extends('layouts.main')
@section('title', 'Nomadic-Studios')
@section('content')
 
<div class="studios-hero">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4">
      <h1>{!! __('studios.top_heading') !!}</h1>
      <p>{!! __('studios.top_desc') !!}</p>
      </div>
    </div>
  </div>
</div>

<section class="section studios-needs-section">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-2 col-xxl-2"></div>
      <div class="col-md-12 col-xl-6 col-xxl-6">
        <h2>{!! __('studios.tailored') !!}</h2>
        <p>{!! __('studios.tailored_desc') !!}</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-2 col-xxl-2"></div>
      <div class="col-md-12 col-xl-10 col-xxl-10 studios-needs-section_needs-types">
        <div class="row">
          <div class="col-md-12 col-xl-6 col-xxl-6">
            <h3>
              <img src="{{asset('images/hub-icon.5425c80c.png')}}">{!! __('studios.hub') !!}
            </h3>
            <p>{!! __('studios.hub_desc') !!}</p>
          </div>
          <div class="col-md-12 col-xl-6 col-xxl-6">
            <h3>
              <img src="{{asset('images/hub-icon1.fa0077e8.png')}}">{!! __('studios.satellites') !!}
            </h3>
            <p>{!! __('studios.satellites_desc') !!}</p>
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-2 col-xxl-2"></div>
      <div class="col-md-12 col-xl-6 col-xxl-6">
        <p>{!! __('studios.tailored_desc2') !!}</p>
      </div>
    </div>
  </div>
</section>

<section class="studios-break"></section>

<section class="section section-with-before-image places-section dark-content container-fluid text-center m-auto d-flex justify-content-center">
  <div class="container">
    <div class="col-md-12 col-xl-6 col-xxl-5 m-auto">
      <h2>{!! __('studios.film_stream') !!}</h2>
      <p>{!! __('studios.film_stream_desc') !!}</p>
      <a href="{{url('studios/video')}}" class="btn section-btn text-decoration-none">{!! __('studios.discover_video_studio') !!}</a>
    </div>
  </div>
</section>


<section class="section studios-shot-section create-music light-content padding-left0">
  <div class="container">
    <div class="row align-items-center justify-content-start">
      <!-- Image Section -->
      <div class="col-md-12 col-xl-6 px-0">
        <img src="{{asset('images/fe/studio-sec-three.png')}}" alt="Capture Perfect Shot" class="img-fluid cm-card section-fade-img section-fade-img-left imgshadow">
      </div>

      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0 d-flex justify-content-end margin-top90">
        <div class="col-md-12 col-xl-11 col-xxl-10">
          <h2>{!! __('studios.capture_shot') !!}</h2>
          <p>{!! __('studios.capture_shot_desc') !!}</p>
          <a href="{{url('studios/photography')}}" class="btn section-btn text-decoration-none">{!! __('studios.learn_more_about_photography_studios') !!}</a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section create-music-section create-music dark-content">
  <div class="container">
    <div class="row justify-content-end">
      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0">
        <div class="col-md-12 col-xl-12 col-xxl-10">
          <!-- <h4>What you need to create</h4> -->
          <h2>{!! __('studios.music_heard') !!}</h2>
          <p>{!! __('studios.music_heard') !!}</p>
          <a href="{{url('studios/music')}}" class="btn section-btn text-decoration-none">{!! __('studios.explore_music_studios') !!}</a>
        </div>
      </div>

      <!-- Image Section -->
      <div class="col-md-12 col-xl-6">
          <img src="{{asset('images/fe/studio-sec-four.png')}}" alt="Creative Space 1" class="img-fluid cm-card section-fade-img section-fade-img-right imgshadow">
      </div>
    </div>
  </div>
</section>

<section class="build-innovate-banner"></section>

<section class="section section-with-before-image places-section light-content container-fluid text-center m-auto d-flex justify-content-center">
  <div class="container">
    <div class="col-md-12 col-xl-6 col-xxl-5 m-auto">
      <h2>{!! __('studios.build_innovate') !!}</h2>
      <p>{!! __('studios.build_innovate_desc') !!}</p>
      <a href="{{url('studios/maker-space')}}" class="btn section-btn text-decoration-none">{!! __('studios.learn_more_about_the_makerspace') !!}</a>
    </div>
  </div>
</section>

<section class="section support-section create-music dark-content padding-left0">
  <div class="container">
    <div class="row align-items-center justify-content-start">
      <!-- Image Section -->
      <div class="col-md-12 col-xl-6 px-0">
        <img src="{{asset('images/fe/studio-sec-six.png')}}" alt="Music Band" class="img-fluid cm-card section-fade-img section-fade-img-left imgshadow">
      </div>

      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0 d-flex justify-content-end margin-top90">
        <div class="col-md-12 col-xl-11 col-xxl-10">
          <h2>{!! __('studios.design_precision') !!}</h2>
          <p>{!! __('studios.design_precision_desc') !!}</p>
          <a href="{{url('studios/fashion')}}" class="btn section-btn text-decoration-none">{!! __('studios.see_fashion_studios') !!}</a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section create-music-section create-music light-content">
  <div class="container">
    <div class="row justify-content-end">
      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0">
        <div class="col-md-12 col-xl-12 col-xxl-10">
          <!-- <h4>What you need to create</h4> -->
          <h2>{!! __('studios.vision') !!}</h2>
          <p>{!! __('studios.vision_desc') !!}</p>
          <a href="{{url('studios/fine-art')}}" class="btn section-btn text-decoration-none">{!! __('studios.explore_art_studios') !!}</a>
        </div>
      </div>

      <!-- Image Section -->
      <div class="col-md-12 col-xl-6">
          <img src="{{asset('images/fe/studio-sec-seven.png')}}" alt="Creative Space 1" class="img-fluid cm-card section-fade-img section-fade-img-right imgshadow">
      </div>
    </div>
  </div>
</section>

@endsection