@extends('layouts.sidebar')
@section('title', 'Nomadic-Locations')
@section('content')
<div class="pagetitle">
  <h1 class="float-start">Locations</h1>
  <button type="button" class="btn float-end addicon"><i class="bi bi-plus"></i> Add New Location</button>
</div><!-- End Page Title -->

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Location</td>
                <td></td>
              </tr>
            </thead>
            <tbody>
              @if(!empty($data) && $data->count())
                @foreach($data as $dt)
                <tr>
                  <td>{{$dt->location}}</td>
                  <td>
                    <i class="bi bi-pencil editicon" data-uuid="{{$dt->id}}"></i>
                  </td>
                </tr>
                @endforeach
              @else
              <tr>
                <td colspan="2">No record found</td>
              </tr>  
              @endif
            </tbody>
            <tfoot>
              <tr>
                <td colspan="2">
                  <div class="foot-paging">
                    {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

    <div class="col-xl-5 user-card" style="display:none;">
      <div class="card thinborder" style="min-height:500px;">
        <div class="card-body pt-3">
        </div>
      </div>
    </div>

  </div>
</section>
@endsection
@section('footer_scripts')
<script>
  $(document).ready(function () {
    $(document).on('click','.searchicon',function(){
      let user_search = $('#user_search').val();
      if($.trim(user_search)!=""){
        window.location.href = APP_URL+'/applications?name='+user_search;
      }
    });

    $(document).on('click', '.addicon, .editicon', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      
      let uuid = $(this).data('uuid');
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, lid:uuid,type:'edit'},
          url: APP_URL+"/location-detail",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });
    
    $(document).on('click', '#btn_saveLocation', function(){
      let obj = $(this);
      obj.attr('disabled',true);
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: $('#updateLocation').serialize(),
          url: APP_URL+"/save-location",
          success: function(res) {
            obj.attr('disabled',false);
            if(res.status){
              $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
              $('#alertMsg').modal('show');
            }
            window.location.reload();
          },
          error: function(res) {
            obj.attr('disabled',false);  
            ajax_error(res);
          }
      });
    });
  });
</script>
@endsection