@if($data)
<div class="row">
  <div class="col-md-7">
    @if($data->profile_pic)
    <img src="{{asset('storage/profile-pic')}}/{{$data->profile_pic}}" class="img-fluid" style="height:100%;">
    @else
    <img src="{{asset('images/user-img.png')}}" class="img-fluid" style="height:100%;">
    @endif
  </div>
  <div class="col-md-5">
    <label class="small text-muted">Email</label>
    <div class="clearboth"></div>
    <label class="small text-muted">
      @if($data->email){{$data->email}}@else No email @endif
    </label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Member since</label>
    <div class="clearboth"></div>
    <label class="small text-muted">{{date('M d, Y',strtotime($data->created_at))}}</label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Total points</label>
    <div class="clearboth"></div>
    <label class="small text-muted">{{$current_balance}} pts</label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Membership level</label>
    <div class="clearboth"></div>
    <label class="small text-muted">@if($data->user_plan){{$data->user_plan->name}}@endif</label>
  </div>
</div>
<div class="row">
  <div class="col-md-12 mt-5">
    <form id="updateUser">
      @csrf
      <input type="hidden" id="user_uuid" name="user_uuid" value="{{$data->uuid}}" readonly>
      <label class="small text-muted">Name</label> 
      <div class="clearboth"></div>
      <label class="lblprofilebind">{{ucfirst($data->fname)}} {{ucfirst($data->lname)}}</label>
      <div class="clearboth"></div>
      <label class="small text-muted">Role</label>
      <div class="clearboth"></div>
      <label class="lblprofilebind">{{ucfirst($data->role)}}</label>
      <div class="clearboth"></div>
      @if($user_permissions)
      <label class="small text-muted mt-2">Existing Permission(s)</label>
      <div class="clearboth"></div>
      <label class="lblprofilebind">
        <ul>
          @foreach($user_permissions as $per)
          <li class="small">{{$per['location']}}
            <ul>
              @foreach($per['roles'] as $role)
              <li class="small">{{$role}}</li>
              @endforeach
            </ul>
          </li>
          @endforeach
        </ul>
      </label>
      <div class="clearboth"></div>
      @endif
      <label class="small text-muted mt-2">Add Permission(s)</label>
      <div class="clearboth"></div>
      <div class="row mb-2">
        <div class="col-md-6 position-relative">
          <select class="form-control" name="location">
            <option value="">Select Location</option>
            @if(in_array(auth()->user()->role,['super-admin','admin']))
            <option value="all">Change Role</option>
            @endif
            @foreach($location as $key=>$val)
            <option value="{{$key}}">{{$val}}</option>
            @endforeach
          </select>
          <i class="bi bi-caret-down-fill searchicon"></i>
        </div>
        <div class="col-md-6 position-relative">
          <select class="form-control" name="role" data-done-button="true" multiple></select>
          <i class="bi bi-caret-down-fill searchicon"></i>
        </div>
      </div>
      <div class="clearboth"></div>
      <div class="position-relative mb-2">
        <input id="btn_addpermission" type="button" class="btn btn-primary mb-2 mt-4" value="Add Permission">
      </div>
      <div class="clearboth"></div>
      <label class="small text-muted mt-4">Add points</label>
      <div class="clearboth"></div>
      <div class="row mb-2">
        <div class="col-md-6">
          <input type="text" class="form-control" name="points" placeholder="Add points">
        </div>
        <div class="col-md-6">
          <input id="btn_addpoints" type="button" class="btn btn-primary" value="Add Points">
        </div>
      </div>
      <div class="clearboth"></div>
      <label class="small text-muted mt-4">Status</label>
      <div class="clearboth"></div>
      <label class="lblprofilebind txt-status">
        @if($data->status==2)<span class="txtApproved">Approved</span>
        @elseif($data->status==3)<span class="txtDenied">Denied</span>
        @elseif($data->status==4)<span class="txtDenied">Suspended</span>
        @elseif($data->status==5)<span class="txtDenied">Blocked</span>
        @endif
      </label>
    </form>
  </div>
</div>
<div class="row mt-3 usraction">
  @if($data->status!=4)
  <div class="col-md-4">
    <input type="button" class="btn btn-dark btnappaction w-100 mb-2 btn-primary" data-type="muser" data-action="4" value="Suspend">
  </div>
  @endif
  @if($data->status!=5)
  <div class="col-md-5">
    <input type="button" class="btn btn-danger btnappaction w-100 mb-2 btn-primary" data-type="muser" data-action="5" value="Block User">
  </div>
  @endif
  @if($data->status==4 || $data->status==5)
  <div class="col-md-5">
    <input type="button" class="btn btn-success btnappaction w-100 mb-2 btn-primary" data-type="muser" data-action="2" value="Make Active">
  </div>
  @endif
</div>
@else
<div align="center">No data found</div>
@endif