@extends('layouts.main')
@section('title', 'Welcome to Nomadic Studios')
@section('content')    
<section class="hero-section">
  <div class="container">
    <div class="row align-items-end">
      <!-- Left Column: Text Content -->
      <div class="col-md-12 col-sm-12 col-xl-6 col-xxl-6 hero-content">  
      <h1>{!! __('home.top_heading') !!}</h1>
      <p>{!! __('home.top_desc') !!}</p>
      </div>

      <!-- Right Column: Image -->
      <div class="col-md-12 col-sm-12 col-xl-6 col-xxl-6 hover-links-container">
        <ul class="hover-links">
          <li class="hoverlinks-create">
            <a href="#" class="hover-effect">{{__('home.create')}}</a>
          </li>
          <li class="hoverlinks-beinspired">
            <a href="#" class="hover-effect">{{__('home.be_inspired')}}</a>
          </li>
          <li class="hoverlinks-collaborate">
            <a href="#" class="hover-effect">{{__('home.collaborate')}}</a>
          </li>
        </ul>
      </div>
    </div>
  </div>
</section>

<section class="video-section video-container">
  <video id="video" src="{{asset('images/band.96c7dbef.mp4')}}" preload="metadata"></video>
  <button class="play-pause-btn" id="playPauseBtn" aria-label="Play"></button>
</section>

<section class="categories-section border-bottom">
  <div class="container text-center">
    <div class="row">
      <div class="col">
        <p class="categories mb-0">
          <a href="{{url('studios/video')}}" class="category-link">{{__('Video')}}</a>
          <span class="plus">+</span>
          <a href="{{url('studios/music')}}" class="category-link">{{__('Music')}}</a>
          <span class="plus">+</span>
          <a href="{{url('studios/photography')}}" class="category-link">{{__('Photography')}}</a>
          <span class="plus">+</span>
          <a href="{{url('studios/fashion')}}" class="category-link">{{__('Fashion')}}</a>
          <span class="plus">+</span>
          <a href="{{url('studios/fine-art')}}" class="category-link">{{__('Visual Art')}}</a>
          <span class="plus">+</span>
          <a href="{{url('studios/maker-space')}}" class="category-link">{{__('Maker')}}</a>
        </p>
      </div>
    </div>
  </div>
</section>

<section class="section create-music-section create-music light-content">
  <div class="container">
    <div class="row justify-content-end">
      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0">
        <div class="col-md-12 col-xl-12 col-xxl-10">
           <h2>{!! __('home.production_studios') !!}</h2>
          <p>{!! __('home.production_studios_desc') !!}</p>
          <a href="{{url('studios')}}" class="btn section-btn text-decoration-none">{{__('home.explore_our_spaces')}}</a>
        </div>
      </div>

      <!-- Image Section -->
      <div class="col-md-12 col-xl-6">
        <div class="image-container section-fade-img section-fade-img-right">
          <img src="{{asset('images/fe/home-sec-one-1.png')}}" alt="Creative Space 1" class="fade-img imgshadow">
          <img src="{{asset('images/fe/home-sec-one-2.png')}}" alt="Creative Space 2" class="fade-img imgshadow">
          <img src="{{asset('images/fe/home-sec-one-3.png')}}" alt="Creative Space 3" class="fade-img imgshadow">
        </div>
      </div>
    </div>
  </div>
</section>

<section class="pre-places-banner"></section>
<section class="places-banner"></section>

<section class="section section-with-before-image places-section dark-content container-fluid text-center m-auto d-flex justify-content-center">
  <div class="container">
    <div class="col-md-12 col-xl-6 col-xxl-5 m-auto">
      <h2>{!! __('home.global_studios') !!}</h2>
      <p>{!! __('home.global_studios_desc') !!}</p>
      <a href="{{url('locations')}}" class="btn section-btn text-decoration-none">{{ __('home.see_our_locations') }}</a>
    </div>
  </div>
</section>

<section class="section people-section create-music light-content padding-left0">
  <div class="container">
    <div class="row align-items-center justify-content-start">
      <!-- Image Section -->
      <div class="col-md-12 col-xl-6 px-0">
        <img src="{{asset('images/fe/home-sec-three.png')}}" alt="Music Band" class="img-fluid cm-card section-fade-img section-fade-img-left imgshadow">
      </div>

      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0 d-flex justify-content-end margin-top90 margin-bottom60">
        <div class="col-md-12 col-xl-11 col-xxl-10">
          <h2>{!! __('home.creative_process') !!}</h2>
          <p>{!! __('home.creative_process_desc') !!}</p>
          <a href="{{url('crew')}}" class="btn section-btn text-decoration-none">{{ __('home.find_your_creative_support') }}</a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section equipment-section create-music dark-content">
  <div class="container">
    <div class="row align-items-center justify-content-end">
      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0">
        <div class="col-md-12 col-xl-12 col-xxl-11">
          <!-- <h4>What you need to create</h4> -->
          <h2>{!! __('home.equipment_create') !!}</h2>
          <p>{!! __('home.equipment_create_desc') !!}
          </p>
          <a href="{{url('equipments')}}" class="btn section-btn text-decoration-none">{{ __('home.discover_our_equipment') }}</a>
        </div>
      </div>

      <!-- Image Section -->
      <div class="col-md-12 col-xl-6">
        <div class="image-container-zooming">
          <img src="{{asset('images/fe/home-sec-four-1.png')}}" alt="Creative Space 1" class="fade-img imgshadow">
          <img src="{{asset('images/fe/home-sec-four-2.png')}}" alt="Creative Space 2" class="fade-img imgshadow">
          <img src="{{asset('images/fe/home-sec-four-3.png')}}" alt="Creative Space 3" class="fade-img imgshadow">
        </div>
      </div>
    </div>
  </div>
</section>

<section class="inspiration"></section>

<section class="section section-with-before-image inspiration-section light-content container-fluid text-center m-auto d-flex justify-content-center">
  <div class="container">
    <div class="col-md-12 col-xl-6 col-xxl-5 m-auto">
      <h2>{!! __('home.exhibitions_and_events') !!}</h2>
      <p>{!! __('home.exhibitions_and_events_desc') !!}</p>
      <a href="{{url('events')}}" class="btn section-btn text-decoration-none">{{ __('home.see_upcoming_events') }}</a>
    </div>
  </div>
</section>

<section class="section support-section create-music dark-content padding-left0">
  <div class="container">
    <div class="row align-items-center justify-content-start">
      <!-- Image Section -->
      <div class="col-md-12 col-xl-6 px-0">
        <img src="{{asset('images/fe/home-sec-six.png')}}" alt="Music Band" class="img-fluid cm-card section-fade-img section-fade-img-left imgshadow">
      </div>

      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0 d-flex justify-content-end margin-top90">
        <div class="col-md-12 col-xl-11 col-xxl-10">
          <h2>{!! __('home.support_create') !!}</h2>
          <p>{!! __('home.support_create_desc') !!}</p>
          <a href="{{url('services')}}" class="btn section-btn text-decoration-none">{{ __('home.explore_our_services') }}</a>
        </div>
      </div>
    </div>
  </div>
</section>


<section class="section connections-section create-music light-content">
  <div class="container">
    <div class="row align-items-center justify-content-end">
      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0">
        <div class="col-md-12 col-xl-11 col-xxl-11">
          <!-- <h4>What you need to create</h4> -->
          <h2>{!! __('home.connect_grow') !!}</h2>
          <p>{!! __('home.connect_grow_desc') !!}</p>
          <a href="{{url('join-our-team')}}" class="btn section-btn text-decoration-none">{{ __('home.join_our_community') }}</a>
        </div>
      </div>

      <!-- Image Section -->
      <div class="col-md-12 col-xl-6 px-0 d-flex justify-content-end">
        <img src="{{asset('images/fe/home-sec-seven.png')}}" alt="Music Band" class="img-fluid cm-card section-fade-img section-fade-img-right imgshadow">
      </div>
    </div>
  </div>
</section>

@endsection