@extends('layouts.'.$layout)
@section('title', 'Nomadic-Event')
@section('content')
<div class="events-details-container">
    <section class="section profile position-relative events-details-hero light-content">
    <div class="col-xl-12">
        <!-- Bordered Tabs -->
        <input type="hidden" id="locationId" name="locationId" value="{{$locationId}}" readonly>
        @if($event)
            @if(isset($event->thumbnail) && $event->thumbnail!="")
            <img src="{{ asset('storage/location/events/' . $event->thumbnail) }}" alt="Event Image" class="img-fluid w-100 " style="border-radius:5px;">
            @endif
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            <div class="container mt-4 center-content events-details-content">
                <h1>{{ ucfirst($event->event_title) }}</h1>
                <h3 >{{ $event->formattedDate() }}</h3>
                <!-- Name of Event Creator -->
                <h2>{{ $event->createdBy->fname.' '.$event->createdBy->lname }}</h2>
                <!-- Edit and Share Buttons with Icons -->
                <div class="d-flex mb-3">
                    @if($layout=='sidebar')
                    <a class="btn section-btn me-1" href="{{url('backend/events/'.$locationId.'/'.$event->event_id)}}" style="display:inline;" ><i class="bi bi-pencil-square"></i></a>
                    @endif
                    <button type="button" onclick="share({{$event->event_id}})" class="btn section-btn"><i class="bi bi-share-fill"></i></button>
                </div>
                <!-- User Icon and Responded Number -->
                <div class="d-flex align-items-center mt-3" style="padding-top:50px;">
                    <i class="bi bi-person-fill"></i>
                    <span class="ml-2" style="padding-left:15px;">{{ $interestedCount }} User Interested</span>&nbsp;/&nbsp; 
                    @if($layout=='sidebar')
                    <!-- <a href="{{url('backend/upcoming-guests/'.$event->event_id)}}" style="display:inline;" >View Guest List</a> -->
                    <a href="{{url('backend/event-responded/'.$locationId.'/'.$event->event_id)}}" style="display:inline;" >View Guest List</a>
                    @endif
                </div>
                <!-- Calendar Icon and Event Date Time -->
                <div class="d-flex align-items-center mt-3">
                    <i class="bi bi-calendar"></i>
                    <span class="ml-2" style="padding-left:15px;">{{ $event->formattedDate() }}</span>
                </div>
                
                <div class="d-flex align-items-center mt-3">
                    <i class="bi bi-geo-alt-fill"></i>
                    @if($event->event_type=='online')
                    <span class="ml-2" style="padding-left:15px;">ONLINE</span>
                    @elseif($event->event_type=='location' && $event->address)
                    <span class="ml-2" style="padding-left:15px;">{{ $event->address }}</span>
                    @endif
                </div>
                
                <!-- Ticket Icon and Ticket Price with Link -->
                <div class="d-flex align-items-center mt-3">
                <i class="bi bi-ticket-perforated"></i>
                    <span class="ml-2" style="padding-left:15px;"> {{ $event->ticket_price }} Points</span>
                </div>
                <!-- Globe Icon and Event Type -->
                <div class="d-flex align-items-center mt-3">
                    <i class="bi bi-globe"></i>
                    <span class="ml-2" style="padding-left:15px;">{{ $event->public_private }}</span>
                </div>
                <!-- Event Description -->
                <div class="mt-3">
                    {!! $event->description !!}
                </div>
                <!-- Participant Heading -->
                <h5 class="mt-4">Participants</h5>
                <!-- Interested and Going Buttons -->
                
                <!-- Interested button form -->
                <button type="button" style="width:250px;padding:19px" class="btn section-btn" @if(Auth::guest()) disabled @elseif(isset($event->interested[0]->user_id)) disabled @else onclick="event_action(this,{{$event->event_id}},'interested')" @endif><span id="interested_count">{{$interestedCount}}</span> </br>Interested <i class="bi bi-hand-thumbs-up"></i></button>

                <!-- Going button form -->
                @if($event->public_private=='public')
                <button type="button" style="width:250px;padding:19px" class="btn section-btn goingevent" data-event="{{$event->event_id}}" @if(Auth::guest()) disabled @elseif(isset($event->going[0]->user_id)) disabled @endif><span>@if(!empty($event->ticket_price)) {{$event->ticket_price}} Points @endif</span></br> Going <i class="bi bi-arrow-right"></i></button>
                @endif

                @if(!is_null($event->playback_url))
                <div class="mt-4 mb-4" align="center" id="video-container" data-playback-url="{{$event->playback_url}}"></div>
                @endif

                @if($event->event_type=='location' && $event->address)
                <h5 class="mt-4">Address</h5>
                <p>{{$event->address}}</p>
                <div class="row mt-5">
                    <div class="col-md-12">
                        <div class="mapouter">
                            <div class="gmap_canvas">
                                <iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=1324&amp;height=400&amp;hl=en&amp;q={{$event->address}}&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                                <a href="https://connectionsgame.org/">Connections Unlimited</a>
                            </div><style>.mapouter{position:relative;text-align:right;width:100%;height:400px;}.gmap_canvas {overflow:hidden;background:none!important;width:100%;height:400px;}.gmap_iframe {height:400px!important;}</style>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        @else
            <p>No event found.</p>
        @endif  
    </div>
    </section>
</div>
@endsection

@section('footer_scripts')
<link href="https://vjs.zencdn.net/8.16.1/video-js.css" rel="stylesheet">
<script src="https://vjs.zencdn.net/8.16.1/video.min.js"></script>
<script>
// Initialize the video player using JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Create a video element
    var videoElement = document.createElement('video');
    videoElement.id = 'my-video';
    videoElement.className = 'video-js vjs-default-skin';
    videoElement.controls = true;
    videoElement.preload = 'auto';
    //videoElement.width = 600;
    //videoElement.height = 400;

    // Add the video element to the container
    document.getElementById('video-container').appendChild(videoElement);

    // Initialize Video.js player with HLS support
    var player = videojs(videoElement, {
        techOrder: ['html5'], // Use the native HTML5 video player
        html5: {
            hls: {
                withCredentials: false // Optional: whether to send cookies with HLS request
            }
        }
    });

    let playback_url = $('#video-container').data('playback-url');
    // Add HLS playback URL to the player
    player.src({
        type: 'application/x-mpegURL',
        src: playback_url
    });
});

$(document).ready(function(){
    
  });
</script>
@endsection