@extends('layouts.sidebar')
@section('title', 'Nomadic-Guest List')
@section('content')
<div class="events-details-container">
  <section class="section profile position-relative events-details-hero light-content">
    <div class="col-xl-12">
      <!-- Bordered Tabs -->
      <input type="hidden" id="locationId" name="locationId" value="{{$locationId}}" readonly>
      @if($event)
        @if(isset($event->thumbnail) && $event->thumbnail!="")
        <img src="{{ asset('storage/location/events/' . $event->thumbnail) }}" alt="Event Image" class="img-fluid w-100 " style="border-radius:5px;">
        @endif
        <div class="container mt-4">
            <!-- Top Event Image -->

            <!-- Event Date and Time -->
            <H3 >{{ $event->formattedDate() }}</H3>

            <!-- Name of Event Creator -->
            <H1>{{ ucfirst($event->event_title) }}</H1>
            <H2>{{ $event->createdBy->fname.' '.$event->createdBy->lname }}</H2>

            @if($layout=='sidebar')
            <div class="row">
              <div class="col-md-6 mb-2 position-relative">
                <a href="{{url('backend/event-detail/'.$locationId.'/'.$event->event_id)}}" class="btn btn-primary" ><i class="bi bi-caret-left-fill"></i> Back to event </a><br/>
              </div>
              <div class="col-md-2 mb-2 position-relative">
                <a class="btn btn-primary" target="_blank" href="{{url('invite-guest/event/'.$event->event_id)}}">Invite Guest</a>
              </div>
              <div class="col-md-4 mb-2 position-relative">
                <form action="{{ route('import.guest.data') }}" id="guest_Data" class="dropzone" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="fallback">
                        <input type="file" name="file" accept=".xlsx, .xls">
                    </div>
                    <input type="hidden" id="guest_event" name="guest_event" value="@if(isset($event->event_id)){{$event->event_id}}@endif" readonly>
                </form>
                <div id="success-message" style="display: none;" class="alert alert-success mt-2">
                    Guest data imported successfully.
                </div>
              </div>
            </div>
            @else
            <!-- <a href="{{url('view-event/'.$event->event_id)}}" class="btn btn-primary" ><i class="bi bi-caret-left-fill"></i> Back to event </a><br/> -->
            @endif

            <h2 class="mt-4">Guest List</h2>

            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            <div class="row">
              <div class="gridcard col-xl-12">
                <div class="card">
                  <div class="row">
                    <div class="col-md-6 mb-2 position-relative">
                      <input type="hidden" id="guestId" value="0" readonly>
                      <input id="search_field" type="text" class="form-control" placeholder="Search">
                      <i class="bi bi-search searchicon"></i>
                    </div>
                  </div>
                  <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
                    <table class="table">
                      <thead>
                        <tr>
                          <th>Date & Time</th>
                          <th>Invitation Type</th>
                          <th>Guest Name</th>
                          <th>Status</th>
                          <th></th>
                        </tr>
                      </thead>
                      <tbody>
                        @if(!empty($data) && $data->count() > 0)
                          @foreach($data as $dt)
                          <tr>
                            <td>{{$dt->invitation_date}} {{$dt->invitation_time}}</td>
                            <td>{{ucfirst($dt->invitation_type)}}</td>
                            <td>{{ucfirst($dt->fname)}} {{ucfirst($dt->lname)}}</td>
                            <td class="guest_{{$dt->guest_uuid}}">
                              @if($dt->status==0) <span class="txtApproved">Invited</span> 
                              @elseif($dt->status==1) <span class="txtPayment">Check In</span> 
                              @elseif($dt->status==2) <span class="txtCancelled">Cancelled</span> 
                              @elseif($dt->status==3) <span class="txtApproved">@if(empty($dt->comp)) Free @else Paid @endif</span>@endif
                            </td>
                            <td>
                              <i id="guest_{{$dt->id}}" class="bi bi-eye vieweye" data-id="{{$dt->id}}" data-status="{{$dt->status}}" data-gfname="{{$dt->fname}}" data-glname="{{$dt->lname}}" data-gemail="{{$dt->email}}" data-hfname="{{$dt->host->fname}}" data-hlname="{{$dt->host->lname}}" data-invitation-date="{{$dt->invitation_date}}" data-invitation-time="{{$dt->invitation_time}}" data-location="{{$dt->location->location}}" data-hpic="{{$dt->host->profile_pic}}"></i>
                            </td>
                          </tr>
                          @endforeach
                        @else
                        <tr>
                          <td colspan="4">No record found</td>
                        </tr>  
                        @endif
                      </tbody>
                      <tfoot>
                        <tr>
                          <td colspan="4">
                            <div class="foot-paging">
                              {!! $data->withQueryString()->links('vendor.pagination.bootstrap-5') !!}
                            </div>  
                          </td>
                        </tr>
                      </tfoot>
                    </table>
                  </div>
                </div>
              </div>
              <div class="col-xl-5 user-card" style="display:none;">
                <div class="card thinborder" style="min-height:400px;">
                  <div class="card-body pt-3">
                    <div class="row">
                      <div class="col-md-6">
                        <img id="hpic" src="" class="img-fluid">
                      </div>
                      <div class="col-md-6">
                        <input type="hidden" id="upcomingid" />
                        <label class="small text-muted">Name</label>
                        <div class="clearboth"></div>
                        <label class="lblprofilebind" id="gname"></label>
                        <div class="clearboth"></div>
                        <label class="small text-muted mt-2">Email</label>
                        <div class="clearboth"></div>
                        <label class="lblprofile" id="gemail"></label>
                        <div class="clearboth"></div>
                        <label class="small text-muted mt-2">Invited By</label>
                        <div class="clearboth"></div>
                        <label class="lblprofile" id="hname"></label>
                      </div>
                    </div>
                    <div class="row mt-2">
                      <div class="col-md-6">
                        <label class="small text-muted">Date</label>
                        <div class="clearboth"></div>
                        <label class="lblprofile" id="invdate"></label>
                      </div>
                      <div class="col-md-6">
                          <label class="small text-muted">Location</label>
                          <div class="clearboth"></div>
                          <label class="lblprofile" id="ulocation"></label>
                      </div>
                    </div>
                    <div class="row mt-4 actionbtns"></div>
                  </div>
                </div>
              </div>
            </div>
            
        </div>
      @else
        <p>No event found.</p>
      @endif
    </div>
  </section>
</div>
@endsection

@section('footer_scripts')
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<style>
.dropzone .dz-message{margin:0;}
.dropzone .dz-message .dz-button{padding:6px 0px 6px 0px;}
</style>
<script>
  Dropzone.autoDiscover = false;
  var guestDropzone = new Dropzone("#guest_Data", {
    maxFiles: 1,
    maxFilesize: 900,
    autoProcessQueue: true, 
    uploadMultiple: false,
    addRemoveLinks: true,
    acceptedFiles: ".xlsx, .xls",
    init: function () {
      var myDropzone = this;
      const messageSpan = document.querySelector("#guest_Data .dz-message .dz-txt");
      if (messageSpan) {
        messageSpan.innerHTML = 'xlsx file, You can download <a href="'+APP_URL+'/invite-guest.xlsx" target="_blank" id="download-link">Sample File</a>';
        // Attach click handler again
        const link = document.querySelector('#download-link');
        if (link) {
          link.addEventListener('click', function (e) {
            e.stopPropagation();
          });
        }
      }
      myDropzone.on("uploadprogress", function (file, progress) {
        $('.progress-text').html(parseInt(progress) + '%');
      });

      myDropzone.on("success", function (file, response) {
        window.location.reload();
      });

      myDropzone.on("error", function (file, response) {
      });
    },
    success: function (file, response) {
    },
    error: function (file, response) {
    }
  });

  $(document).ready(function (){
    $(document).on('click', '.vieweye', function(){
      console.log(111);
      view_guest($(this));
    });

    $(document).on('click', '.invaction', function(){ 
      let status = $(this).data('status');
      let upcoming_id = $('#upcomingid').val();
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, upcoming_id:upcoming_id, status:status},
        url: APP_URL+"/invite-action",
        success: function(res) {
          if(res.status){
            window.location.reload();
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });
  });
</script>
@endsection