@if(session()->has('notifications') && count(session()->get('notifications')) > 0)
  @foreach(session()->get('notifications') as $notifi)
    @if($notifi->type=='booking' && $notifi->action=='cancelled')
    <li class="notification-item p-3">
      <i class="bi bi-x-circle text-danger"></i>
      <div>
        <h4>Booking Cancelled</h4>
        <p>{!! $notifi->content !!}</p>
        <p><a href="{{url('booking-confirmed/'.$notifi->reference_id)}}"><span class="badge rounded-pill bg-primary p-2 ms-2">View Booking</span></a></p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='booking' && $notifi->action=='confirmed')
    <li class="notification-item p-3">
      <i class="bi bi-check-circle text-success"></i>
      <div>
        <h4>Booking Confirmed</h4>
        <p>{!! $notifi->content !!}</p>
        <p><a href="{{url('booking-confirmed/'.$notifi->reference_id)}}"><span class="badge rounded-pill bg-primary p-2 ms-2">View Booking</span></a></p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='point' && $notifi->action=='POINTS_PURCHASED')
    <li class="notification-item p-3">
      <i class="bi bi-info-circle text-primary"></i>
      <div>
        <h4>Purchased Points</h4>
        <p>{!! $notifi->content !!}</p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='point' && $notifi->action=='POINTS_RECEIVED')
    <li class="notification-item p-3">
      <i class="bi bi-info-circle text-primary"></i>
      <div>
        <h4>Points Received</h4>
        <p>{!! $notifi->content !!}</p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='point' && $notifi->action=='POINTS_EXPIRED')
    <li class="notification-item p-3">
      <i class="bi bi-info-circle text-primary"></i>
      <div>
        <h4>Points Expired</h4>
        <p>{!! $notifi->content !!}</p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='point' && $notifi->action=='POINTS_SENT')
    <li class="notification-item p-3">
      <i class="bi bi-info-circle text-primary"></i>
      <div>
        <h4>Points Sent</h4>
        <p>{!! $notifi->content !!}</p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='point' && $notifi->action=='POINTS_SENT_EVENT')
    <li class="notification-item p-3">
      <i class="bi bi-info-circle text-primary"></i>
      <div>
        <h4>Points Sent For EVENT</h4>
        <p>{!! $notifi->content !!}</p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='point' && $notifi->action=='POINTS_RECEIVED_EVENT')
    <li class="notification-item p-3">
      <i class="bi bi-info-circle text-primary"></i>
      <div>
        <h4>Points Received For Event</h4>
        <p>{!! $notifi->content !!}</p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='point' && $notifi->action=='MEMBERSHIP_CREDIT')
    <li class="notification-item p-3">
      <i class="bi bi-info-circle text-primary"></i>
      <div>
        <h4>Membership Credit</h4>
        <p>{!! $notifi->content !!}</p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @elseif($notifi->type=='subscription' && $notifi->action=='cancelled')
    <li class="notification-item p-3">
      <i class="bi bi-info-circle text-primary"></i>
      <div>
        <h4>Subscription Cancelled</h4>
        <p>{!! $notifi->content !!}</p>
      </div>
    </li>
    <li>
      <hr class="dropdown-divider">
    </li>
    @endif
  @endforeach
@else
<li class="notification-item p-3">
  <div class="ms-3">Notifications not available.</div>
</li>
@endif