<header class="header">
  <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenu" aria-labelledby="offcanvasMenuLabel">
    <div class="offcanvas-header">
      <!-- <h5 class="offcanvas-title" id="offcanvasMenuLabel">Menu</h5> -->
      <button type="button" class="btn-close text-reset menu-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
      <ul class="nav flex-column mx-auto">
        <li class="nav-item">
          <a class="nav-link" href="{{url('studios')}}">Studios</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{url('locations')}}">Locations</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{url('crew')}}">People</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{url('equipments')}}">Equipment</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{url('events')}}">Events</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{url('services')}}">Services</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="{{url('news')}}">News</a>
        </li>
      </ul>
      <!-- Language & Sign-up button -->
      <div class="navbar-sidecontainer-offcanvas">
        @if (Auth::guest())  
        <a class="btn-signup" href="{{url('choose-your-plan')}}">Sign up <img src="{{asset('images/arrow-up-right.62414968.svg')}}" alt="signup"></a>
        <a class="btn-signup" href="{{url('login')}}">Sign in <img src="{{asset('images/arrow-up-right.62414968.svg')}}" alt="signin"></a>
        @else
        <a class="btn-signup" href="{{url('account-setting')}}">Account Setting<img src="{{asset('images/arrow-up-right.62414968.svg')}}" alt="Account Setting"></a>
        
        @if(auth()->user()->role=='super-admin' || session()->has('page_access'))  
        <a class="btn-signup" href="{{url('backend/dashboard')}}">{{__('Dashboard')}}<img src="{{asset('images/arrow-up-right.62414968.svg')}}" alt="Dashboard"></a>    
        @endif
        <a class="btn-signup" href="{{route('logout')}}">Logout<img src="{{asset('images/arrow-up-right.62414968.svg')}}" alt="Logout"></a>
        @endif
      </div>
    </div>
  </div>

  <nav class="navbar navbar-expand-xl navbar-light fixed-top">
    <div class="container-fluid navbar-innercontainer">
      <!-- Navbar brand -->
      <a class="navbar-brand" href="{{url('/')}}">
        <!-- <img src="{{asset('images/logo.bb83845b.svg')}}" alt="Nomadic Studio"> -->
        <img src="{{asset('images/logob.png')}}" alt="Nomadic Studio" width="100" height="41">
      </a>

      <i class="bi bi-list toggle-sidebar-btn" style="display:none;"></i>

      <!-- Collapsible navigation links -->
      <div id="navbarNav" class="collapse navbar-collapse">
        <ul class="navbar-nav">
          <li class="nav-item">
            <a class="nav-link" href="{{url('studios')}}">{{__('Studios')}}</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="{{url('locations')}}">{{__('Locations')}}</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="{{url('crew')}}">{{__('People')}}</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="{{url('equipments')}}">{{__('Equipment')}}</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="{{url('events')}}">{{__('Events')}}</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="{{url('services')}}">{{__('Services')}}</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="{{url('news')}}">{{__('News')}}</a>
          </li>
        </ul>
      </div>

      <!-- Language & Sign-up button -->
      <div class="navbar-sidecontainer">
        <!-- <a href="#" class="navbar-language" data-bs-toggle="modal" data-bs-target="#Languageandregion"><img src="{{asset('images/globe.a123ec85.svg')}}" alt="globe"></a> -->
        @if (Auth::guest())
        <a class="btn btn-signup" href="{{url('choose-your-plan')}}">{{__('Sign up')}} <img src="{{asset('images/arrow-up-right.62414968.svg')}}" alt="signup"></a>
        <a class="btn btn-signup" href="{{url('login')}}">{{__('Sign in')}} <img src="{{asset('images/arrow-up-right.62414968.svg')}}" alt="signin"></a>
        @else
          <a href="#" class="navbar-language notificationBell" data-bs-toggle="dropdown">
            @if(session()->has('unread_noti') && session()->get('unread_noti') > 0)  
            <img src="{{asset('images/bell-notification.d984c52e.svg')}}" alt="notification">
            @else
            <img src="{{asset('images/bell.173c56cd.svg')}}" alt="notification">
            @endif
          </a>
          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow notifications overflow-auto" style="max-height:600px">@include('notification')</ul>
          
          <a href="{{url('discuss')}}" class="navbar-language"><img src="{{asset('images/message.9a99e419.svg')}}" alt="message"></a>
          <!-- <a href="#" class="navbar-language" style="display:none"><img src="{{asset('images/message-notification.01bf09f1.svg')}}"></a> -->

          <a href="{{url('account-setting')}}#booking-tab" class="navbar-language">{{session()->get('point_balance')}} pts <img src="{{asset('images/money-wallet.f0cf0e4d.svg')}}" alt="wallet"></a>
          
          <a href="#" class="" data-bs-toggle="dropdown">
            @if(is_null(auth()->user()->profile_pic))
            <!-- <i class="bi bi-person-circle" style="font-size: 35px;"></i> -->
            <img src="{{asset('images/user-img.png')}}" alt="Profile" class="rounded-circle" width="35px">
            @else
            <img src="{{url('/')}}/storage/profile-pic/{{auth()->user()->profile_pic}}" alt="Profile" class="rounded-circle" width="38px" height="38px">
            @endif
          </a>
          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
            <li class="dropdown-header" style="text-align: left;">
              <h5 class="text-left">{{auth()->user()->fname}} {{auth()->user()->lname}}</h5>
              <!-- <span>Web Designer</span> -->
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="{{url('home')}}">
                <i class="bi bi-house"></i>
                <span>{{__('Home')}}</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="{{url('account-setting')}}">
                <i class="bi bi-gear"></i>
                <span>{{__('Account Settings')}}</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            @if(auth()->user()->role=='super-admin' || session()->has('page_access'))  
            <li>
              <a class="dropdown-item d-flex align-items-center" href="{{url('backend/dashboard')}}">
                <i class="bi bi-lock"></i>
                <span>{{__('Dashboard')}}</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            @endif
            <!-- <li>
              <a class="dropdown-item d-flex align-items-center" href="#">
                <i class="bi bi-question-circle"></i>
                <span>Need Help?</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li> -->

            <li>
              <a class="dropdown-item d-flex align-items-center" href="{{route('logout')}}">
                <i class="bi bi-box-arrow-right"></i>
                <span>{{__('Sign Out')}}</span>
              </a>
            </li>

          </ul>
        @endif
      </div>

      <button class="navbar-toggler float-end" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasMenu" aria-controls="offcanvasMenu" aria-label="offcanvasMenu" style="border:none;">
        <!-- <span class="navbar-toggler-icon"></span> -->
        <i class="bi bi-three-dots-vertical"></i>
      </button>
    </div>
  </nav>
</header>