@extends('layouts.sidebar')
@section('title', 'Nomadic-Rentals')
@section('content')
<section class="section profile position-relative">
  <div class="col-xl-12">
    <!-- Bordered Tabs -->
    <input type="hidden" id="daily_rate" value="{{convertCurrency($equipment->cost_per_day)}}">
    <input type="hidden" id="hourly_rate" value="{{convertCurrency($equipment->cost_per_hour)}}">
    <input type="hidden" id="locationId" name="locationId" value="{{$locationId}}" readonly>
    <input type="hidden" id="equipmentId" name="equipmentId" value="{{$equipmentId}}" readonly>
    <div class="tab-content pt-2" id="borderedTabContent">
      <div class="tab-pane fade show active" id="bordered-Schedule" role="tabpanel" aria-labelledby="Schedule-tab">
        <div class="row">
          <div class="col-md-8">
            <h3 class="mb-4">{{$equipment->name}}</h3>
            <div id="calendar"></div>
          </div>
          <div class="col-md-4">
              <div class="col-md-12 p-0">
                <form id="scheduleCalendar">
                  @csrf
                  <input type="hidden" id="type" name="type" value="rental" readonly>
                  <input type="hidden" id="refrence_id" name="refrence_id" value="{{$equipmentId}}" readonly>
                  <input type="hidden" id="schedule_id" name="schedule_id" value="">
                  <input type="hidden" id="edit_schedule_type" name="edit_schedule_type" value="">
                  <input type="hidden" id="schedule_location" name="schedule_location" value="{{$locationId}}">
                  <h5 class="fw-bolder mt-2">Availability & prices</h5>

                  <label>Minimum Booking Time</label>
                  <div class="row mb-3">
                    <div class="col-md-4 position-relative mb-1">
                      <select class="form-control" id="min_days" name="min_days">
                        <option value="0" selected>Days</option>
                        @for ($i = 1; $i <= 30; $i++)
                          @php $value = str_pad($i, 2, '0', STR_PAD_LEFT); @endphp
                          <option value="{{ $value }}" @if($i==$min_booking['min_days']) selected @endif>{{ $value }}</option>
                        @endfor
                      </select>
                      <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    <div class="col-md-4 position-relative mb-1">
                      <select class="form-control" id="min_hours" name="min_hours">
                        <option value="00">Hours</option>  
                        @for ($i = 1; $i <= 23; $i++)
                          @php $value = str_pad($i, 2, '0', STR_PAD_LEFT); @endphp
                          <option value="{{ $value }}" @if(($i==2 && empty($min_booking['min_hours'])) || $i==$min_booking['min_hours']) selected @endif>{{ $value }}</option>
                        @endfor
                      </select>
                      <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    <div class="col-md-4 position-relative mb-1">
                      <select class="form-control" id="min_minutes" name="min_minutes">
                        <option value="00" @if(00==$min_booking['min_minutes']) selected @endif>Minutes</option>  
                        <option value="15" @if(15==$min_booking['min_minutes']) selected @endif>15</option>
                        <option value="30" @if(30==$min_booking['min_minutes']) selected @endif>30</option>
                        <option value="45" @if(45==$min_booking['min_minutes']) selected @endif>45</option>
                      </select>
                      <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                  </div>

                  <label>Maximum Booking Time</label>
                  <div class="row mb-3">
                    <div class="col-md-4 position-relative mb-1">
                      <select class="form-control" id="max_days" name="max_days">
                        <option value="0">Days</option>
                        @for ($i = 1; $i <= 30; $i++)
                          @php $value = str_pad($i, 2, '0', STR_PAD_LEFT); @endphp
                          <option value="{{ $value }}" @if(($i==5 && empty($max_booking['max_days'])) || $i==$max_booking['max_days']) selected @endif>{{ $value }}</option>
                        @endfor
                      </select>
                      <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    <div class="col-md-4 position-relative mb-1">
                      <select class="form-control" id="max_hours" name="max_hours">
                        <option value="00">Hours</option>  
                        @for ($i = 1; $i <= 23; $i++)
                          @php $value = str_pad($i, 2, '0', STR_PAD_LEFT); @endphp
                          <option value="{{ $value }}" @if($i==$max_booking['max_hours']) selected @endif>{{ $value }}</option>
                        @endfor
                      </select>
                      <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    <div class="col-md-4 position-relative mb-1">
                      <select class="form-control" id="max_minutes" name="max_minutes">
                        <option value="00" @if(00==$max_booking['max_minutes']) selected @endif>Minutes</option>  
                        <option value="15" @if(15==$max_booking['max_minutes']) selected @endif>15</option>
                        <option value="30" @if(30==$max_booking['max_minutes']) selected @endif>30</option>
                        <option value="45" @if(45==$max_booking['max_minutes']) selected @endif>45</option>
                      </select>
                      <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                  </div>

                  <div class="row mt-3">
                    <div class="col-md-12 position-relative">
                      <select class="form-control" name="availability_type">
                        <option value="0">Daily availability</option>
                        <option value="1">Recurring availability</option>
                      </select>
                      <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                  </div>
                  <div id="dailyAvailCont" class="mt-3">
                    <div style="overflow-x:auto">
                      <table class="table table-borderless tbl_boolingdtlsiner avlpricetbl">
                        <thead class="borderbottomnone">
                          <tr>
                            <td class="avltxt" colspan="3"><i class="bi bi-clock"></i> Daily Availability</td>
                            <td class="avltxtsmall">Daily ({{session()->get('user_currency')}})</td>
                            <td class="avltxtsmall">Hourly ({{session()->get('user_currency')}})</td>
                            <td class="avltxt"><i id="add_daily_click" class="bi bi-plus float-right f20"></i></td>
                          </tr>
                        </thead>  
                        <tbody id="daily_container">
                          <tr>
                            <td>
                              <input name="daily_start_date[0]" type="date" class="form-control"  style="width:100px;" data-index="0" onkeyup="validateDateTime(0)">
                            </td>
                            <td><input name="daily_start_time[0]" type="text" class="form-control timepicker" placeholder="Start time" readonly data-index="0" onkeyup="validateDateTime(0)"></td>
                            <td><input name="daily_end_time[0]" type="text" class="form-control timepicker1" placeholder="End time" readonly data-index="0" onkeyup="validateDateTime(0)"></td>
                            <td><input name="daily_daily_rate[0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_day)}}"></td>
                            <td><input name="daily_hourly_rate[0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_hour)}}"></td>
                            <td><i class="bi bi-trash daily-trash f20"></i></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                    <div class="clearfix"></div>
                  </div>
                  <div id="recuAvailCont" class="mt-4" style="display:none;">
                    <div style="overflow-x:auto">
                      <table class="table table-borderless tbl_boolingdtlsiner mt-4 avlpricetbl">
                        <thead class="borderbottomnone">
                          <tr>
                            <td class="avltxt" colspan="3"><i class="bi bi-clock"></i> Recurring Availability</td>
                            <td class="avltxtsmall">Daily ({{session()->get('user_currency')}})</td>
                            <td class="avltxtsmall">Hourly ({{session()->get('user_currency')}})</td>
                            <td class="avltxt"></td>
                          </tr>
                        </thead>
                        <tbody>
                          <tr class="row-0">
                            <td class="fw-bold"><input class="recurrchk" data-day="0" name="recurring_days[0]" type="checkbox" value="0">Mon</td>
                            <td>
                              <input name="recurring_start_time[0][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(0,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[0][0]" type="text" class="form-control timepicker1" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(0,0)">
                            </td>
                            <td><input name="recurring_daily_rate[0][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_day)}}"></td>
                            <td><input name="recurring_hourly_rate[0][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_hour)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="0"></i>
                            </td>
                          </tr>
                          <tr class="row-1">
                            <td class="fw-bold"><input class="recurrchk" data-day="1" name="recurring_days[1]" type="checkbox" value="1">Tue</td>
                            <td>
                              <input name="recurring_start_time[1][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(1,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[1][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(1,0)">
                            </td>
                            <td><input name="recurring_daily_rate[1][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_day)}}"></td>
                            <td><input name="recurring_hourly_rate[1][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_hour)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="1"></i>
                            </td>
                          </tr>
                          <tr class="row-2">
                            <td class="fw-bold"><input class="recurrchk" data-day="2" name="recurring_days[2]" type="checkbox" value="2">Wed</td>
                            <td>
                              <input name="recurring_start_time[2][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(2,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[2][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(2,0)">
                            </td>
                            <td><input name="recurring_daily_rate[2][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_day)}}"></td>
                            <td><input name="recurring_hourly_rate[2][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_hour)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="2"></i>
                            </td>
                          </tr>
                          <tr class="row-3">
                            <td class="fw-bold"><input class="recurrchk" data-day="3" name="recurring_days[3]" type="checkbox" value="3">Thu</td>
                            <td>
                              <input name="recurring_start_time[3][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(3,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[3][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(3,0)">
                            </td>
                            <td><input name="recurring_daily_rate[3][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_day)}}"></td>
                            <td><input name="recurring_hourly_rate[3][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_hour)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="3"></i>
                            </td>
                          </tr>
                          <tr class="row-4">
                            <td class="fw-bold"><input class="recurrchk" data-day="4" name="recurring_days[4]" type="checkbox" value="4">Fri</td>
                            <td>
                              <input name="recurring_start_time[4][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(4,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[4][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(4,0)">
                            </td>
                            <td><input name="recurring_daily_rate[4][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_day)}}"></td>
                            <td><input name="recurring_hourly_rate[4][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_hour)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="4"></i>
                            </td>
                          </tr>
                          <tr class="row-5">
                            <td class="fw-bold"><input class="recurrchk" data-day="5" name="recurring_days[5]" type="checkbox" value="5">Sat</td>
                            <td>
                              <input name="recurring_start_time[5][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(5,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[5][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(5,0)">
                            </td>
                            <td><input name="recurring_daily_rate[5][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_day)}}"></td>
                            <td><input name="recurring_hourly_rate[5][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_hour)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="5"></i>
                            </td>
                          </tr>
                          <tr class="row-6">
                            <td class="fw-bold"><input class="recurrchk" data-day="6" name="recurring_days[6]" type="checkbox" value="6">Sun</td>
                            <td>
                              <input name="recurring_start_time[6][0]" type="text" data-index="0" class="form-control timepicker" placeholder="Start time" readonly onkeyup="validateDateTimeRecu(6,0)">
                            </td>
                            <td>
                              <input name="recurring_end_time[6][0]" type="text" class="form-control timepicker1" placeholder="End time" readonly onkeyup="validateDateTimeRecu(6,0)">
                            </td>
                            <td><input name="recurring_daily_rate[6][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_day)}}"></td>
                            <td><input name="recurring_hourly_rate[6][0]" type="number" class="form-control" placeholder="0" value="{{convertCurrency($equipment->cost_per_hour)}}"></td>
                            <td>
                              <i class="bi bi-plus add-recurring-days f20" data-day="6"></i>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  <!-- <h6 class="fw-bold mt-3 mb-3"><i class="bi bi-globe2"></i> Timeszones</h6> -->
                  <div class="col-md-12 mb-2 mt-2 position-relative">
                    <!-- <select class="form-control">
                      <option>Bali, Indonesia (GMT + 8)</option>
                    </select> 
                    <i class="bi bi-caret-down-fill searchicon rgt0"></i> -->
                    <div class="text-center mt-4 mb-2">
                      <button id="schedule_save" type="button" class="btn btn-primary">Save</button>
                      <button id="schedule_reset" type="button" class="btn btn-primary">Reset</button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
        </div>
      </div>
    </div>
    <!-- End Bordered Tabs -->
  </div>
</section>
<!-- end planner modal -->
@endsection
@section('footer_scripts')
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/index.global.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/@fullcalendar/bootstrap5@6.1.9/index.global.min.js'></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.js"></script>
<link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
<link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
<script src="{{asset('js/dropzone.js')}}"></script>
<script>
  $(document).ready(function () {
    scheduleCalendarInit();
  });
</script>
@endsection