<div class="modal-dialog">
    <div class="modal-content" style="background:#f2eeeb;">
        <div class="modal-header">
          <h4 class="modal-title">Buy More Points</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <p>Enter number of points to buy.</p>
            
            <div class="row mt-4">
                <div class="col-md-12 position-relative">
                    <select name="payment_method" id="payment_method" class="form-control w-100">
                        @forelse($paymentMethods as $method)
                            <option value="{{ $method->id }}" @if($method->id === optional(auth()->user()->defaultPaymentMethod())->id) selected @endif>
                                {{ ucfirst($method->card->brand) }} .... {{ $method->card->last4 }} 
                                @if($method->id === optional(auth()->user()->defaultPaymentMethod())->id) - Default @endif
                            </option>
                        @empty
                            <option disabled selected>No payment method available</option>
                        @endforelse
                    </select>
                    <i class="bi bi-caret-down-fill searchicon"></i>

                    <p class="mt-3 text-sm text-gray-600">
                        <a href="{{url('add-payment-method')}}" class="text-blue-600 hover:underline">
                            <i class="bi bi-plus " style="color:black;font-size: 16px;"></i>Add a new payment method
                        </a>
                    </p>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-md-12">
                    <div class="input-group mb-3">
                        <input type="hidden" id="points_per_usd" value="{{$points_per_usd}}" readonly/>
                        <input id="txt_points" type="number" class="form-control" placeholder="Points to buy" />
                        <div class="input-group-append">
                            <span class="form-control input-group-text" id="txt_amount" style="width:70px !important;">$0.00</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <input type="button" class="btn btn-dark w-30 mr-2" value="Cancel" data-bs-dismiss="modal" aria-label="Close">
            <input disabled id="btn_buypoints" type="button" class="btn btn-primary w-30" value="Buy Points">
        </div>
    </div>
</div>