@extends('layouts.main')
@section('title', 'Nomadic-Studios')
@section('content')
 
<div class="studios-hero">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-4 col-xxl-4">
        <h1>The Space<br>to Create</h1>
        <p>
          At Nomadic Studios, we offer purpose-built spaces that adapt to your
          craft. By combining different creative disciplines under one roof, we
          empower creators to connect, collaborate, and elevate their work.
          Whether you’re producing a film, recording music, or crafting a
          prototype, you’ll find the tools, community, and flexibility you need
          to create.
        </p>
      </div>
    </div>
  </div>
</div>

<section class="section studios-needs-section">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-xl-2 col-xxl-2"></div>
      <div class="col-md-12 col-xl-6 col-xxl-6">
        <h2>
          Studios Tailored to<br>Your Needs, Anywhere
        </h2>
        <p>
          Nomadic Studios offers two types of spaces to support creators wherever they work:
        </p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-2 col-xxl-2"></div>
      <div class="col-md-12 col-xl-10 col-xxl-10 studios-needs-section_needs-types">
        <div class="row">
          <div class="col-md-12 col-xl-6 col-xxl-6">
            <h3>
              <img src="{{asset('images/hub-icon.5425c80c.png')}}">Nomadic Hubs
            </h3>
            <p>
              Our flagship, multidisciplinary spaces are designed to support creators across a range of disciplines. These studios provide a consistent, full-service experience with the tools, spaces, and environment to explore and collaborate.
            </p>
          </div>
          <div class="col-md-12 col-xl-6 col-xxl-6">
            <h3>
              <img src="{{asset('images/hub-icon1.fa0077e8.png')}}">Nomadic Satellites
            </h3>
            <p>
              Partnered with independently operated studios, these locations focus on one or two disciplines, offering specialized environments that reflect a diverse range of talent and facilities.
            </p>
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 col-xl-2 col-xxl-2"></div>
      <div class="col-md-12 col-xl-6 col-xxl-6">
        <p>
          Together, Hubs and Satellites expand your options, giving you access to a wider variety of spaces and talent. Your membership opens the door to creativity, collaboration, and connection, wherever you are.
        </p>
      </div>
    </div>
  </div>
</section>

<section class="studios-break"></section>

<section class="section section-with-before-image places-section dark-content container-fluid text-center m-auto d-flex justify-content-center">
  <div class="container">
    <div class="col-md-12 col-xl-6 col-xxl-5 m-auto">
      <h2>
        Film, Stream, and<br>Edit Like a Pro
      </h2>

      <p>
        Whether you’re filming, livestreaming, or editing, our video studios are built for every stage of production. From multi-camera setups to podcasting and post-production stations, you’ll find the perfect space to bring your story to the screen.
      </p>
      <a href="{{url('studios/video')}}" class="btn section-btn text-decoration-none">Discover Video Studio</a>
    </div>
  </div>
</section>


<section class="section studios-shot-section create-music light-content padding-left0">
  <div class="container">
    <div class="row align-items-center justify-content-start">
      <!-- Image Section -->
      <div class="col-md-12 col-xl-6 px-0">
        <img src="{{asset('images/capture.15bc2323.png')}}" alt="Capture Perfect Shot" class="img-fluid cm-card section-fade-img section-fade-img-left">
      </div>

      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0 d-flex justify-content-end margin-top90">
        <div class="col-md-12 col-xl-11 col-xxl-10">
          <h2>Capture the Perfect Shot</h2>

          <p>
            Our photography studios are equipped for everything from product shoots to portrait sessions. With professional lighting setups and adaptable backdrops, you can focus on creating images that inspire.
          </p>
          <a href="{{url('studios/photography')}}" class="btn section-btn text-decoration-none">Learn More About Photography Studios</a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section create-music-section create-music dark-content">
  <div class="container">
    <div class="row justify-content-end">
      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0">
        <div class="col-md-12 col-xl-12 col-xxl-10">
          <!-- <h4>What you need to create</h4> -->
          <h2>
            Spaces to Make Your Music Heard
          </h2>

          <p>
            Whether you're a solo artist or part of a band, our music studios offer the ideal setup for recording, producing, and mixing. With high-quality acoustics and professional-grade equipment, it’s time to turn up the volume on your creativity.
          </p>
          <a href="{{url('studios/music')}}" class="btn section-btn text-decoration-none">Explore Music Studios</a>
        </div>
      </div>

      <!-- Image Section -->
      <div class="col-md-12 col-xl-6">
          <img src="{{asset('images/spaces.249f4d07.png')}}" alt="Creative Space 1" class="img-fluid cm-card section-fade-img section-fade-img-right">
      </div>
    </div>
  </div>
</section>

<section class="build-innovate-banner"></section>

<section class="section section-with-before-image places-section light-content container-fluid text-center m-auto d-flex justify-content-center">
  <div class="container">
    <div class="col-md-12 col-xl-6 col-xxl-5 m-auto">
      <h2>
        Build, Innovate, and Experiment
      </h2>

      <p>
        For creators who love to tinker and build, our makerspaces are equipped with tools for 3D printing, welding, electronics, laser cutting, and more. It’s a playground for inventors and problem-solvers.
      </p>
      <a href="{{url('studios/maker-space')}}" class="btn section-btn text-decoration-none">Learn More About the Makerspace</a>
    </div>
  </div>
</section>


<section class="section support-section create-music dark-content padding-left0">
  <div class="container">
    <div class="row align-items-center justify-content-start">
      <!-- Image Section -->
      <div class="col-md-12 col-xl-6 px-0">
        <img src="{{asset('images/fashion.a2be3dff.png')}}" alt="Music Band" class="img-fluid cm-card section-fade-img section-fade-img-left">
      </div>

      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0 d-flex justify-content-end margin-top90">
        <div class="col-md-12 col-xl-11 col-xxl-10">
          <h2>Design and Create with Precision</h2>

          <p>
            From designing to constructing, our fashion studios provide the tools and space to bring your ideas to life. Whether you're sewing, pattern-making, or preparing costumes, you'll find everything you need to craft with style.
          </p>
          <a href="{{url('studios/fashion')}}" class="btn section-btn text-decoration-none">See Fashion Studios</a>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="section create-music-section create-music light-content">
  <div class="container">
    <div class="row justify-content-end">
      <!-- Text Section -->
      <div class="col-md-12 col-xl-6 col-xxl-5 pl-0 pr-0">
        <div class="col-md-12 col-xl-12 col-xxl-10">
          <!-- <h4>What you need to create</h4> -->
          <h2>
            Spaces to Bring Your Vision to Life
          </h2>

          <p>
            For painters, sculptors, and visual artists of all kinds, our art studios are designed to inspire. With ample light, adaptable setups, and space for every medium, you’ll have everything you need to create your next masterpiece.
          </p>
          <a href="{{url('studios/fine-art')}}" class="btn section-btn text-decoration-none">Explore Art Studios</a>
        </div>
      </div>

      <!-- Image Section -->
      <div class="col-md-12 col-xl-6">
          <img src="{{asset('images/vision-life.9a578143.png')}}" alt="Creative Space 1" class="img-fluid cm-card section-fade-img section-fade-img-right">
      </div>
    </div>
  </div>
</section>

@endsection