@extends('layouts.settings')
  @section('title', 'Nomadic-Account Setting')
  @section('content')
  <div class="banner"></div>
  <div class="container position-relative" data-aos="fade-up" style="top:50px;padding-bottom:30px;">
    <h2 class="mt-4 mb-4">{{__('Account Settings')}}</h2>
    @if (session('error'))
    <div class="alert alert-danger p-2">{{session('error')}}</div>
    @elseif (session('success'))
    <div class="alert alert-success p-2">{{session('success')}}</div>
    @endif
    <span id="page" style="display:none;">account-setting</span>
    <!-- Responsive Tab Dropdown for Mobile -->
    <div class="d-block d-md-none mb-3 position-relative">
      <select class="form-control" id="accountTabDropdown">
        <option value="#bordered-profile">My Profile</option>
        <option value="#bordered-membership">Membership</option>
        <option value="#bordered-booking">Points Balance</option>
        <option value="#bordered-cards">Cards</option>
        <option value="#bordered-security">Security</option>
        <option value="calendar">Calendar</option>
      </select>
      <i class="bi bi-caret-down-fill searchicon"></i>
    </div>
    <div class="row mb-5 d-block">
      <div class="col-xl-12">
        <ul class="nav nav-tabs nav-tabs-bordered d-none d-md-flex" id="borderedTab2" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#bordered-profile" type="button" role="tab" aria-controls="Profile" aria-selected="true">My Profile</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="membership-tab" data-bs-toggle="tab" data-bs-target="#bordered-membership" type="button" role="tab" aria-controls="Membership" aria-selected="false">Membership</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="booking-tab" data-bs-toggle="tab" data-bs-target="#bordered-booking" type="button" role="tab" aria-controls="Booking" aria-selected="false">Points Balance</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="cards" data-bs-toggle="tab" data-bs-target="#bordered-cards" type="button" role="tab" aria-controls="Cards" aria-selected="false">Cards</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="security-tab" data-bs-toggle="tab" data-bs-target="#bordered-security" type="button" role="tab" aria-controls="Security" aria-selected="false">Security</button>
          </li>
          <li class="nav-item" role="presentation">
            <a class="nav-link" href="{{url('account-setting-calendar')}}">Calendar</a>
          </li>
        </ul>
        <div class="tab-content pt-2" id="borderedTabContent2">
          <div class="tab-pane fade show active" id="bordered-profile" role="tabpanel" aria-labelledby="profile-tab">
            <div class="row">
              <div class="col-xl-3">
                <label class="lblprofile">Your Profile Picture</label>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="row">
                  <div class="col-md-7 mb-2 position-relative">
                    <div id="dispbannerimg" class="mb-3">
                      @if($data->profile_pic)
                      <img src="{{asset('storage/profile-pic')}}/{{$data->profile_pic}}" class="img-fluid w-100" style="border-radius: 5px;">
                      @else
                      <img src="{{asset('images/user-img.png')}}" class="img-fluid w-100" style="border-radius: 5px;">
                      @endif
                    </div>
                    <form action="{{url('save-profile-picture')}}" method="post" enctype="multipart/form-data" id="imageUpload" class="dropzone">
                      @csrf
                      <input type="hidden" name="type" value="profile" readonly>
                    </form>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <label class="lblprofile">Personal Info</label>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="row">
                  <div class="col-md-7 mb-2 position-relative">
                    <input type="text" class="form-control" placeholder="First Name" name="fname" value="{{$data->fname}}">
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-7 mb-2 position-relative">
                    <input type="text" class="form-control" placeholder="Last Name" name="lname" value="{{$data->lname}}">
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <label class="lblprofile">Bio</label>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="row">
                  <div class="col-md-7 mb-2 position-relative">
                    <textarea name="description" class="form-control txtarea mb-3" rows="8">{{auth()->user()->description}}</textarea>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <label class="lblprofile">Price ({{session()->get('user_currency')}})</label>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="row">
                  <div class="col-md-7 mb-2 position-relative">
                    <input type="number" class="form-control" placeholder="Daily Rate" name="daily_rate" value="{{convertCurrency($data->daily_rate)}}">
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-7 mb-2 position-relative">
                    <input type="number" class="form-control" placeholder="Hourly Rate" name="hourly_rate" value="{{convertCurrency($data->hourly_rate)}}">
                  </div>
                </div>
              </div>
            </div>

            <div class="row mt-3">
              <div class="col-md-6 text-end">
                <input id="btn_saveaccount" type="button" class="btn btn-primary mb-2 mt-4" value="Save changes">
              </div>
            </div>
          </div>
          <div class="tab-pane fade" id="bordered-membership" role="tabpanel" aria-labelledby="membership-tab">
            <div class="mb-4">
              <div class="heading3 mt-3 mb-2">Membership level</div>
              <div class="col-md-12 border border-dark p-3">
              @if($plan)
                <div class="mb-4">{{$plan->name}}</div>
                <h3 class="mb-4"><b>${{$plan->price}}</b><span>/{{$plan->frequency}}</span></h3>
                @if(auth()->user()->pm_type && auth()->user()->pm_type=='visa')
                <img src="{{asset('images/icon-visa.png')}}" alt="visa" width="25" height="25">
                @elseif(auth()->user()->pm_type && auth()->user()->pm_type=='master')
                <img src="{{asset('images/icon-mastercard.png')}}" alt="visa" width="25" height="25">
                @else
                <img src="{{asset('images/icon-card.png')}}" alt="Credit Card" width="25" height="25">
                @endif
                <span class="ms-3">****{{auth()->user()->pm_last_four}}</span>
                @if($next_billing_date!="")
                <div>Your next billing date is {{$next_billing_date}}</div>
                @endif
                <div><i class="bi bi-check2 me-2"></i>{{$plan->points}} Pts</div>
                <div><i class="bi bi-check2 me-2"></i>
                @if($plan->stripe_plan=="")
                Must be invited by member
                @else
                Book up {{$plan->advance_duration}} {{$plan->advance_frequency}} in advance
                @endif
                </div>
                <div><i class="bi bi-check2 me-2"></i>{{$guests[$plan->num_of_guest]}} guests</div>

                <div>
                  @if($plan->slug!="guest")
                  <input type="button" class="btn btn-danger subplancancel w-30 mb-2" value="Cancel Plan">
                  @endif
                  <a class="btn btn-dark w-30 mb-2" href="{{url('change-plan')}}">Change Plan</a>
                </div>
              @else
                <div class="mb-4">Guest</div>
              @endif
              </div>
            </div>
            <div class="ms-1">
              <div class="heading3 ps-0 mb-2">Transactions</div>
              <table class="table">
                <thead>  
                  <tr>
                    <td>Date</td>
                    <td>Status</td>
                    <td>Total cost</td>
                  </tr>
                </thead>
                <tbody>
                  @foreach($points as $point)
                  @if($point->action=='MEMBERSHIP_CREDIT' || $point->action=='POINTS_PURCHASED')
                  <tr>
                    <td>{{date('d M Y',strtotime($point->created_at))}}</td>
                    <td>{{$points_action[$point->action]}} @if($point->plan_id) ({{$point->plan->name}}) @endif</td>
                    <td>@if($point->amount){{convertCurrency($point->amount)}}@else 0 @endif {{session()->get('user_currency')}}</td>
                  </tr>
                  @endif
                  @endforeach
                </tbody>
              </table>
            </div> 
          </div>
          <div class="tab-pane fade" id="bordered-booking" role="tabpanel" aria-labelledby="booking-tab">
            <div class="mb-4">
              <div class="heading3 mt-3 mb-2">Points balance</div>
              <div class="col-md-6 border border-dark">
                <div class="row p-2 pt-4">
                  <div class="col-md-6">Last month booking cost</div>
                  <div class="col-md-5 text-end">{{$last_month_booking_cost}}pts</div>
                </div>
                <div class="row p-2">
                  <div class="col-md-6">Current month booking cost</div>
                  <div class="col-md-5 text-end">{{$current_month_booking_cost}}pts</div>
                </div>
                <div class="row p-2 pb-4">
                  <div class="col-md-6"><b>Current balance</b></div>
                  <div class="col-md-5 text-end"><b>{{$current_balance}}pts</b></div>
                </div>
                <div class="p-2 mt-5">
                  <input type="button" class="btn btn-primary w-30 mb-2 buypoints" data-type="cancel" value="Buy more points">
                  <input type="button" class="btn btn-dark transferpoint w-30 mb-2" data-type="change" value="Transfer point">
                </div>
              </div>
            </div>
            <div class="row ms-1">
              <div class="heading3 ps-0 mb-2">Transactions</div>
              <table class="table">
                <thead>  
                  <tr>
                    <td>Date</td>
                    <td>Status</td>
                    <td>Total cost</td>
                  </tr>
                </thead>
                <tbody>
                  @foreach($points as $point)
                  <tr>
                    <td>{{date('d M Y',strtotime($point->created_at))}}</td>
                    <td>{{$points_action[$point->action]}}</td>
                    <td>
                      @if($point->receivedby_uuid==env('NOMADIC_ACCOUNT_UUID'))
                        @if($point->action=='POINTS_SENT_EVENT' || $point->action=='POINTS_SENT' || $point->action=='BOOK_EVENT' || $point->action=='BOOKING_CANCELLED') {{$point->debit}}pts
                        @else {{$point->credit}}pts @endif
                      @else
                        @if($point->action=='POINTS_SENT_EVENT' || $point->action=='POINTS_SENT' || $point->action=='BOOK_EVENT' || $point->action=='BOOKING_CONFIRMED') {{$point->debit}}pts
                        @else {{$point->credit}}pts @endif
                      @endif
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div> 
          </div>
          <div class="tab-pane fade" id="bordered-cards" role="tabpanel" aria-labelledby="cards-tab">
            <div class="mb-4">
              <div class="col-md-9 heading3">Payment methods</div>
              <div class="col-md-3">
                <a href="{{url('add-payment-method')}}" class="btn">
                  <i class="bi bi-plus " style="color:black;font-size: 16px;"></i>Add a new payment method
                </a>
              </div>
            </div>
            <div class="ms-1">
              <table class="table">
                <tbody>
                  @foreach($payment_methods as $method)
                  <tr id="pmd_{{$method->id}}">
                    <td>
                      @if($method->card->brand && $method->card->brand=='visa')
                      <img src="{{asset('images/icon-visa.png')}}" alt="visa" width="35" height="35">
                      @elseif($method->card->brand && $method->card->brand=='mastercard')
                      <img src="{{asset('images/icon-mastercard.png')}}" alt="visa" width="35" height="35">
                      @elseif($method->card->brand && $method->card->brand=='amex')
                      <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" width="35px" height="35px"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="#1574bc" d="M325.1 167.8c0-16.4-14.1-18.4-27.4-18.4l-39.1-.3v69.3H275v-25.1h18c18.4 0 14.5 10.3 14.8 25.1h16.6v-13.5c0-9.2-1.5-15.1-11-18.4 7.4-3 11.8-10.7 11.7-18.7zm-29.4 11.3H275v-15.3h21c5.1 0 10.7 1 10.7 7.4 0 6.6-5.3 7.9-11 7.9zM279 268.6h-52.7l-21 22.8-20.5-22.8h-66.5l-.1 69.3h65.4l21.3-23 20.4 23h32.2l.1-23.3c18.9 0 49.3 4.6 49.3-23.3 0-17.3-12.3-22.7-27.9-22.7zm-103.8 54.7h-40.6v-13.8h36.3v-14.1h-36.3v-12.5h41.7l17.9 20.2zm65.8 8.2l-25.3-28.1L241 276zm37.8-31h-21.2v-17.6h21.5c5.6 0 10.2 2.3 10.2 8.4 0 6.4-4.6 9.2-10.5 9.2zm-31.6-136.7v-14.6h-55.5v69.3h55.5v-14.3h-38.9v-13.8h37.8v-14.1h-37.8v-12.5zM576 255.4h-.2zm-194.6 31.9c0-16.4-14.1-18.7-27.1-18.7h-39.4l-.1 69.3h16.6l.1-25.3h17.6c11 0 14.8 2 14.8 13.8l-.1 11.5h16.6l.1-13.8c0-8.9-1.8-15.1-11-18.4 7.7-3.1 11.8-10.8 11.9-18.4zm-29.2 11.2h-20.7v-15.6h21c5.1 0 10.7 1 10.7 7.4 0 6.9-5.4 8.2-11 8.2zm-172.8-80v-69.3h-27.6l-19.7 47-21.7-47H83.3v65.7l-28.1-65.7H30.7L1 218.5h17.9l6.4-15.3h34.5l6.4 15.3H100v-54.2l24 54.2h14.6l24-54.2v54.2zM31.2 188.8l11.2-27.6 11.5 27.6zm477.4 158.9v-4.5c-10.8 5.6-3.9 4.5-156.7 4.5 0-25.2 .1-23.9 0-25.2-1.7-.1-3.2-.1-9.4-.1 0 17.9-.1 6.8-.1 25.3h-39.6c0-12.1 .1-15.3 .1-29.2-10 6-22.8 6.4-34.3 6.2 0 14.7-.1 8.3-.1 23h-48.9c-5.1-5.7-2.7-3.1-15.4-17.4-3.2 3.5-12.8 13.9-16.1 17.4h-82v-92.3h83.1c5 5.6 2.8 3.1 15.5 17.2 3.2-3.5 12.2-13.4 15.7-17.2h58c9.8 0 18 1.9 24.3 5.6v-5.6c54.3 0 64.3-1.4 75.7 5.1v-5.1h78.2v5.2c11.4-6.9 19.6-5.2 64.9-5.2v5c10.3-5.9 16.6-5.2 54.3-5V80c0-26.5-21.5-48-48-48h-480c-26.5 0-48 21.5-48 48v109.8c9.4-21.9 19.7-46 23.1-53.9h39.7c4.3 10.1 1.6 3.7 9 21.1v-21.1h46c2.9 6.2 11.1 24 13.9 30 5.8-13.6 10.1-23.9 12.6-30h103c0-.1 11.5 0 11.6 0 43.7 .2 53.6-.8 64.4 5.3v-5.3H363v9.3c7.6-6.1 17.9-9.3 30.7-9.3h27.6c0 .5 1.9 .3 2.3 .3H456c4.2 9.8 2.6 6 8.8 20.6v-20.6h43.3c4.9 8-1-1.8 11.2 18.4v-18.4h39.9v92h-41.6c-5.4-9-1.4-2.2-13.2-21.9v21.9h-52.8c-6.4-14.8-.1-.3-6.6-15.3h-19c-4.2 10-2.2 5.2-6.4 15.3h-26.8c-12.3 0-22.3-3-29.7-8.9v8.9h-66.5c-.3-13.9-.1-24.8-.1-24.8-1.8-.3-3.4-.2-9.8-.2v25.1H151.2v-11.4c-2.5 5.6-2.7 5.9-5.1 11.4h-29.5c-4-8.9-2.9-6.4-5.1-11.4v11.4H58.6c-4.2-10.1-2.2-5.3-6.4-15.3H33c-4.2 10-2.2 5.2-6.4 15.3H0V432c0 26.5 21.5 48 48 48h480.1c26.5 0 48-21.5 48-48v-90.4c-12.7 8.3-32.7 6.1-67.5 6.1zm36.3-64.5H575v-14.6h-32.9c-12.8 0-23.8 6.6-23.8 20.7 0 33 42.7 12.8 42.7 27.4 0 5.1-4.3 6.4-8.4 6.4h-32l-.1 14.8h32c8.4 0 17.6-1.8 22.5-8.9v-25.8c-10.5-13.8-39.3-1.3-39.3-13.5 0-5.8 4.6-6.5 9.2-6.5zm-57 39.8h-32.2l-.1 14.8h32.2c14.8 0 26.2-5.6 26.2-22 0-33.2-42.9-11.2-42.9-26.3 0-5.6 4.9-6.4 9.2-6.4h30.4v-14.6h-33.2c-12.8 0-23.5 6.6-23.5 20.7 0 33 42.7 12.5 42.7 27.4-.1 5.4-4.7 6.4-8.8 6.4zm-42.2-40.1v-14.3h-55.2l-.1 69.3h55.2l.1-14.3-38.6-.3v-13.8H445v-14.1h-37.8v-12.5zm-56.3-108.1c-.3 .2-1.4 2.2-1.4 7.6 0 6 .9 7.7 1.1 7.9 .2 .1 1.1 .5 3.4 .5l7.3-16.9c-1.1 0-2.1-.1-3.1-.1-5.6 0-7 .7-7.3 1zm20.4-10.5h-.1zm-16.2-15.2c-23.5 0-34 12-34 35.3 0 22.2 10.2 34 33 34h19.2l6.4-15.3h34.3l6.6 15.3h33.7v-51.9l31.2 51.9h23.6v-69h-16.9v48.1l-29.1-48.1h-25.3v65.4l-27.9-65.4h-24.8l-23.5 54.5h-7.4c-13.3 0-16.1-8.1-16.1-19.9 0-23.8 15.7-20 33.1-19.7v-15.2zm42.1 12.1l11.2 27.6h-22.8zm-101.1-12v69.3h16.9v-69.3z"/></svg>
                      @else
                      <img src="{{asset('images/icon-card.png')}}" alt="Credit Card" width="35" height="35">
                      @endif
                      {{ ucfirst($method->card->brand) }}
                    </td>
                    <td>.... {{ $method->card->last4 }}</td>
                    <td> @if($method->id === optional(auth()->user()->defaultPaymentMethod())->id) Default @endif
                    </td>
                    <td>
                      <i class="bi bi-trash pointer delpm" title="Remove card" data-pmid="{{$method->id}}"></i>
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div> 
          </div>
          <div class="tab-pane fade" id="bordered-security" role="tabpanel" aria-labelledby="security-tab">
            <div class="row">
              <div class="col-xl-3">
                <label class="lblprofile mt-4">Phone number</label>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="row">
                  <div class="col-md-7 mb-2 position-relative">
                    <input type="tel" placeholder="Mobile Number" id="telephone" class="form-control shadow-none" maxlength="14"/>
                    <span id="msg" class="error"></span>
                    <input type="hidden" id="mobile_number" name="phone_number" value="{{$data->mobile_number}}"/>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                <label class="lblprofile  mt-4">Email</label>
              </div>
              <div class="col-xl-6 mt-4">
                <div class="row">
                  <div class="col-md-7 mb-2 position-relative">
                    <input name="email" class="form-control mb-3" placeholder="Email" value="{{auth()->user()->email}}" />
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-xl-3">
                  <label class="lblprofile">
                  <a href="{{url('reset-password')}}" class="color-none">Reset Password</a>
                  <svg
                    class="_252"
                    width="24"
                    height="25"
                    viewBox="0 0 24 25"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      fill-rule="evenodd"
                      clip-rule="evenodd"
                      d="M17.5712 9.24819L6.55037 20.269L5.13616 18.8548L16.157 7.83397L7.25748 7.83397L7.25748 5.83397L19.5712 5.83397L19.5712 18.1477L17.5712 18.1477L17.5712 9.24819Z"
                      fill="#111111"
                    />
                  </svg>
                </label>
              </div>
            </div>

            <div class="row mt-3">
              <div class="col-md-6 text-end">
                <input id="btn_savesecurity" type="button" class="btn btn-primary mb-2 mt-4" value="Save changes">
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  @endsection
  @section('footer_scripts')
  <link href="{{asset('css/dropzone.min.css')}}" rel="stylesheet">
  <link href="{{asset('css/dropzone.custom.css')}}" rel="stylesheet">
  <script src="{{asset('js/dropzone.js')}}"></script>
  <link rel="stylesheet" href="{{asset('css/intlTelInput.css')}}">
  <script src="{{asset('js/intlTelInput.js')}}"></script>
  <script>
    var errorMap = ["{{__('Invalid number')}}", "{{__('Invalid country code')}}", "{{__('Too short')}}", "{{__('Too long')}}"];
    var input = document.querySelector("#telephone");
    var msg = document.querySelector("#msg");
    var intl = window.intlTelInput(input, {
        autoPlaceholder: false,
        separateDialCode: true,
        placeholderNumberType: "MOBILE",
        utilsScript: "{{asset('js/utils.js')}}"
    });
    // Validate on blur event
    input.addEventListener('keyup', function() {
        if(input.value.trim()){
            if(intl.isValidNumber()){
                input.classList.remove("error");
                msg.classList.add("hide");
                //msg.hide();
            }else{
                input.classList.add("error");
                var errorCode = intl.getValidationError();
                msg.innerHTML = errorMap[errorCode];
                msg.classList.remove("hide");
                //msg.show();
            }
        }
        let full_number = intl.getNumber();
        $('#mobile_number').val(full_number);
    });
    // input.addEventListener('keyup', (e) => {
    //     let val = e.target.value;
    //     e.target.value = val
    //     .replace(/\D/g, '')
    //     .replace(/(\d{1,4})(\d{1,3})?(\d{1,3})?/g, function(txt, f, s, t) {
    //         if (t) {
    //             return `(${f}) ${s}-${t}`
    //         } else if (s) {
    //             return `(${f}) ${s}`
    //         } else if (f) {
    //             return `(${f})`
    //         }
    //     });
    // });
    intl.setNumber($('#mobile_number').val());
    
    Dropzone.autoDiscover = false;
    var myDropzone = new Dropzone("#imageUpload",{ 
        maxFiles: 1,
        maxFilesize: 100,
        autoProcessQueue: true,
        uploadMultiple: false, 
        addRemoveLinks: true,
        acceptedFiles: ".jpeg,.jpg,.png"
    });
    myDropzone.on("uploadprogress", function (file, progress) {
        $('.progress-text').html(parseInt(progress)+'%');
    });
    myDropzone.on("error", function (file, errorMessage) {
        $('.progress-text').html('0%').hide();
    });
    myDropzone.on("success", function (file, response) {
        $('.progress-text').html('0%').hide();
        $('#dispbannerimg').html('<img src="'+APP_URL+'/storage/profile-pic/'+response.success+'" class="img-fluid w-100" style="border-radius:5px;">');
    });
  
    $(document).ready(function () {
      
      $(document).on('click','.transferpoint',function(){
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token},
            url: APP_URL+"/transfer-points",
            success: function(res) {
                if(res.status){
                  $('#otp_modal').html(res.content).modal('show');
                }
            },
            error: function(res) {                    
                ajax_error(res);
            }
        });
      });
      $(document).on('click', '.subplancancel', function(){
        let obj = $(this);
        obj.attr('disabled',true);
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token},
            url: APP_URL+"/subscription-cancel",
            success: function(res) {
              obj.attr('disabled',false);
              if(res.status){
                $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                $('#alertMsg').modal('show');
              }
            },
            error: function(res) {
              obj.attr('disabled',false);  
              ajax_error(res);
            }
        });
      });
      $(document).on('click', '#btn_saveaccount', function(){
        let obj = $(this);
        obj.attr('disabled',true);
        let fname = $('input[name="fname"]').val();
        let lname = $('input[name="lname"]').val();
        let description = $('textarea[name="description"]').val();
        let daily_rate = $('input[name="daily_rate"]').val();
        let hourly_rate = $('input[name="hourly_rate"]').val();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, fname:fname, lname:lname, description:description, daily_rate:daily_rate, hourly_rate:hourly_rate},
            url: APP_URL+"/account-setting-save",
            success: function(res) {
              obj.attr('disabled',false);
              if(res.status){
                $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                $('#alertMsg').modal('show');
              }
            },
            error: function(res) {
              obj.attr('disabled',false);  
              ajax_error(res);
            }
        });
      });
      $(document).on('click', '#btn_savesecurity', function(){
        let obj = $(this);
        obj.attr('disabled',true);
        let email = $('input[name="email"]').val();
        let phone_number = $('input[name="phone_number"]').val();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, email:email, phone_number:phone_number},
            url: APP_URL+"/otp-verification-profile",
            success: function(res) {
              obj.attr('disabled',false);
              if(res.status && res.content!=""){
                $('#otp_modal').html(res.content).modal('show');
                OTPInput();
              }
            },
            error: function(res) {
              obj.attr('disabled',false);  
              ajax_error(res);
            }
        });
      });

      $(document).on('click','#btn_otpverify',function(){
          if($('#otpForm').valid()){
              $('#btn_otpverify .spinner').show();
              $.ajax({
                  type: 'POST',
                  dataType: 'json',
                  data: $('#otpForm').serialize(),
                  url: APP_URL+"/verify-otp-profile",
                  success: function(res) {
                      $('#btn_otpverify .spinner').hide();
                      if(res.status){
                        $('#otp_modal').html('').modal('hide');
                        $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">Changes updated successfully.</div>');
                        $('#alertMsg').modal('show');
                      }
                  },
                  error: function(res) {                    
                      $('#btn_otpverify .spinner').hide();
                      ajax_error(res);
                  }
              });
          }
      });

      $(document).on('click','.send-otp',function(){
          let otpfield;
          let type = $(this).data('type');
          if(type=='email'){
              otpfield = $('#email').val();
          }else{
              otpfield = $('#mobile_number').val();
          }
          $.ajax({
              type: 'POST',
              dataType: 'json',
              data: {_token:_token, type:type, otpfield:otpfield},
              url: APP_URL+"/send-otp",
              success: function(res) {
                  if(res.status){
                      $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                      $('#alertMsg').modal('show');
                  }
              },
              error: function(res) {
                  ajax_error(res);
              }
          });
      });
      
      $(document).on('click','.delpm',function(){
          if(confirm('Are you sure want to remove this card?')){
            let pmid = $(this).data('pmid');
            $.ajax({
                type: 'POST',
                dataType: 'json',
                data: {_token:_token, pmid:pmid},
                url: APP_URL+"/payment-method-delete",
                success: function(res) {
                    if(res.status){
                      $('#pmd_'+pmid).remove();
                      $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                      $('#alertMsg').modal('show');
                    }
                },
                error: function(res) {
                  ajax_error(res);
                }
            });
          }
      });

      // Sync dropdown and tab selection
      
      var dropdown = document.getElementById('accountTabDropdown');
      if(dropdown) {
        dropdown.addEventListener('change', function() {
          var val = this.value;
          if(val === 'calendar') {
            window.location.href = "{{ url('account-setting-calendar') }}";
          } else {
            var tabTrigger = document.querySelector('[data-bs-target="' + val + '"]');
            if(tabTrigger) {
              var tab = new bootstrap.Tab(tabTrigger);
              tab.show();
              document.querySelector(val).scrollIntoView({behavior: 'smooth'});
            }
          }
        });
        // Set dropdown to current tab
        var activeTab = document.querySelector('#borderedTab2 .nav-link.active');
        if(activeTab) {
          var target = activeTab.getAttribute('data-bs-target');
          dropdown.value = target;
        }
      }
    });
  </script>
  @endsection