<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/login', [AuthController::class, 'login']);
Route::post('/send-otp', [AuthController::class, 'send_otp']);
Route::post('/verify-otp', [AuthController::class, 'verify_otp']);

Route::get('/locations', [AuthController::class, 'locations']);
Route::get('/studios/{location_id}', [AuthController::class, 'studios']);
Route::get('/peoples', [AuthController::class, 'peoples']);
Route::get('/events', [AuthController::class, 'events']);

Route::middleware('auth:api')->group(function () {
    Route::get('/user', [AuthController::class, 'user']);
    Route::post('/logout', [AuthController::class, 'logout']);
});
