
<?php $__env->startSection('title', 'Nomadic-Schedule Events'); ?>
<?php $__env->startSection('content'); ?>
<section class="section profile position-relative">
  <div class="col-xl-12">
    <!-- Bordered Tabs -->
    <input type="hidden" id="locationId" name="locationId" value="<?php echo e($locationId); ?>" readonly>
    <ul class="nav nav-tabs nav-tabs-bordered position-relative" id="borderedTab" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="Schedule-tab" data-bs-toggle="tab" data-bs-target="#bordered-Schedule" type="button" role="tab" aria-controls="Schedule" aria-selected="true">Schedule</button>
      </li>
      
    </ul>
    <div class="tab-content pt-2" id="borderedTabContent">
      <div class="tab-pane fade show active" id="bordered-Schedule" role="tabpanel" aria-labelledby="Schedule-tab">
        <div class="row">
          <div class="col-md-12">
            <div id="calendar"></div>
          </div>
        </div>
      </div>
      
      
    </div>
    <!-- End Bordered Tabs -->
  </div>
</section>
<!-- start create planner modal -->

<!-- end planner modal -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/index.global.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/@fullcalendar/bootstrap5@6.1.9/index.global.min.js'></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    var calendarEl = document.getElementById('calendar');
    var modal = document.getElementById("createplanner");
    var calendar = new FullCalendar.Calendar(calendarEl, {
        timeZone: 'UTC',
        themeSystem: 'bootstrap5',
        headerToolbar: {
            left: 'today prev,next',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay'
        },
        navLinks: true,
        selectable: true,
        nowIndicator: true,
        dayMaxEvents: true,
        editable: true,
        selectable: true,
        businessHours: false,
        dayMaxEvents: true,
        weekNumbers: false,
        dayMaxEvents: true,
        events: <?php echo json_encode($events, 15, 512) ?>,
		
eventClick: function (info) {
	console.log('Event Clicked:', info.event);
    if (info.event.start) {
		
        let startTime = info.event.start.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: true });
        let startDate = info.event.start.getDay() + ' ' + months[info.event.start.getMonth()] + ' ' + info.event.start.getFullYear() + ' ' + startTime;
        let fixedEndTime = new Date(info.event.start);
        fixedEndTime.setHours(0, 0, 0);
        let endTime = fixedEndTime.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: true });
        let endDate = fixedEndTime.getDay() + ' ' + months[fixedEndTime.getMonth()] + ' ' + fixedEndTime.getFullYear() + ' ' + endTime;

       window.location.href = "<?php echo e(url('backend/event-detail')); ?>/<?php echo e($locationId); ?>/"+info.event.id;

    } else {
        console.error('Event start time is null.');
    }
},


        eventDrop: function (info) {
            var newDate = new Date(info.event.start);
            if (newDate < Date.now()) {
                info.revert();
            }
        }
    });
    calendar.render();
    var evt = document.createEvent('UIEvents');
    evt.initUIEvent('resize', true, false, window, 0);
    window.dispatchEvent(evt);
});

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/managing/schedule-events.blade.php ENDPATH**/ ?>