
<?php $__env->startSection('title', 'Nomadic Studios | Invite your guest'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Join global creatives')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/banner1.png')); ?>">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="mt-4 mb-4"><?php echo e(__('Invite your guest')); ?> <?php if($type && $id): ?> - <?php echo e(ucfirst($type)); ?> (<?php echo e($id); ?>) <?php endif; ?></h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-4">
             <?php if(session('success')): ?>
            <div class="alert alert-success p-2"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
            <form action="<?php echo e(route('invite.guest.process')); ?>" method="POST" id="invite" class="w-100">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="num" value="<?php echo e($id); ?>" readonly>
                <input type="hidden" name="type" value="<?php echo e($type); ?>" readonly>
                <div class="form-container">
                    <div class="form-group mb-2">Select Location</div>
                    <div class="form-group mb-2 position-relative">
                        <select class="form-control shadow-none" <?php if(isset($loc)): ?> disabled <?php endif; ?> name="location_id" id="txt_location">
                            <option value="">Location</option>
                            <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php if(isset($loc) && $loc==$key): ?> selected <?php endif; ?>><?php echo e($val); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    <?php if($type=='event'): ?>
                    <div class="form-group mb-2">Select Event</div>
                    <div class="form-group mb-2 position-relative">
                        <select class="form-control shadow-none" name="event_id" id="txt_event"S>
                            <option value="">Event</option>
                            <?php $__currentLoopData = $event_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ev->event_id); ?>" <?php if($id==$ev->event_id): ?> selected <?php endif; ?>><?php echo e($ev->event_title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <i class="bi bi-caret-down-fill searchicon"></i>
                    </div>
                    <?php endif; ?>
                    <div class="form-group mb-2">Details of your guest</div>
                    <div class="form-group mb-2">
                        <input type="text" id="fname" name="fname" class="form-control shadow-none" placeholder="<?php echo e(__('First Name')); ?>" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="text" id="lname" name="lname" class="form-control shadow-none" placeholder="<?php echo e(__('Last Name')); ?>" />
                    </div>
                    <div class="form-group mb-2">
                        <input type="email" id="email" name="email" class="form-control shadow-none" placeholder="<?php echo e(__('Email')); ?>" />
                    </div>

                    <div class="form-group mb-2 <?php if($type=='event'): ?> d-none <?php endif; ?>">Select Date and Time</div>
                    <div class="form-group mb-2 <?php if($type=='event'): ?> d-none <?php endif; ?>">
                        <input type="date" id="txt_date" name="invitation_date" class="form-control shadow-none" value="<?php echo e((isset($start_date)) ? $start_date : ''); ?>" <?php if(isset($start_date)): ?> disabled <?php endif; ?>/>
                    </div>
                    <div class="form-group mb-2 <?php if($type=='event'): ?> d-none <?php endif; ?>">
                        <input type="time" name="invitation_time" value="<?php echo e((isset($start_time)) ? $start_time : ''); ?>" class="form-control shadow-none" <?php if(isset($start_time)): ?> disabled <?php endif; ?>/>
                    </div>
                    
                    <?php if($type=='event'): ?>
                    <div class="form-group mb-2">
                        <input type="tel" placeholder="<?php echo e(__('Mobile Number')); ?>" id="telephone" class="form-control shadow-none" maxlength="14"/>
                        <span id="msg" class="error"></span>
                        <input type="hidden" id="mobile_number" name="mobile_number"/>
                    </div>

                    <div class="form-group mb-2">Event Price - <?php echo e($ticket_price_local); ?> (<?php echo e(session()->get('user_currency')); ?>)</div>
                    <div class="form-group input-group mb-2">
                        <input type="number" id="comp" name="comp" class="form-control shadow-none" placeholder="Event price in points" value="<?php echo e($ticket_price); ?>" />
                        <span class="input-group-text" id="basic-addon2">Points</span>
                    </div>
                    <?php endif; ?>

                    <div class="btnconter mt-3 mb-4">
                        <input type="submit" class="btn btn-primary" name="submit" value="<?php echo e(__('Invite Guest')); ?>" />
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/intlTelInput.css')); ?>">
<script src="<?php echo e(asset('js/intlTelInput.js')); ?>"></script> 
<script>
    var errorMap = ["<?php echo e(__('Invalid number')); ?>", "<?php echo e(__('Invalid country code')); ?>", "<?php echo e(__('Too short')); ?>", "<?php echo e(__('Too long')); ?>"];
    var input = document.querySelector("#telephone");
    var msg = document.querySelector("#msg");
    var intl = window.intlTelInput(input, {
        autoPlaceholder: false,
        separateDialCode: true,
        placeholderNumberType: "MOBILE",
        utilsScript: "<?php echo e(asset('js/utils.js')); ?>"
    });
    // Validate on blur event
    input.addEventListener('keyup', function() {
        if(input.value.trim()){
            if(intl.isValidNumber()){
                input.classList.remove("error");
                msg.classList.add("hide");
                //msg.hide();
            }else{
                input.classList.add("error");
                var errorCode = intl.getValidationError();
                msg.innerHTML = errorMap[errorCode];
                msg.classList.remove("hide");
                //msg.show();
            }
        }
        let full_number = intl.getNumber();
        $('#mobile_number').val(full_number);
    });
    $(document).on('change','#txt_event',function(){
        let val = $(this).val();
        if(val!=""){
            window.location.href = APP_URL+'/invite-guest/event/'+val;
        }
    });
    
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/guest/invite.blade.php ENDPATH**/ ?>