
<?php $__env->startSection('title', 'Nomadic-Billing'); ?>
<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Billing</h1>
</div><!-- End Page Title -->

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="heading3 ps-0 mb-2">Transactions</div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Date</td>
                <td>Status</td>
                <td>Amount</td>
                <td>User</td>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e(date('d M Y',strtotime($point->created_at))); ?></td>
                <td><?php echo e($points_action[$point->action]); ?> <?php if($point->plan_id): ?> (<?php echo e($point->plan->name); ?>) <?php endif; ?></td>
                <td><?php if($point->amount): ?><?php echo e(convertCurrency($point->amount)); ?><?php else: ?> 0 <?php endif; ?> <?php echo e(session()->get('user_currency')); ?></td>
                <td>
                  <?php if(isset($point->receivedby->fname)): ?>
                  <?php echo e($point->receivedby->fname); ?> <?php echo e($point->receivedby->lname); ?>

                  <?php endif; ?>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
              <tr>
                <td colspan="5">
                  <div class="foot-paging">
                    <?php echo $data->withQueryString()->links('vendor.pagination.bootstrap-5'); ?>

                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script>
  $(document).ready(function () {
    $(document).on('click', '.vieweye', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      
      let uuid = $(this).data('uuid');
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, uuid:uuid, type:'view'},
          url: APP_URL+"/userinfo",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });

  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/global/billing.blade.php ENDPATH**/ ?>