
<?php $__env->startSection('title', 'Nomadic-Event'); ?>
<?php $__env->startSection('content'); ?>
<div class="events-details-container">
    <section class="section profile position-relative events-details-hero light-content">
    <div class="col-xl-12">
        <!-- Bordered Tabs -->
        <input type="hidden" id="locationId" name="locationId" value="<?php echo e($locationId); ?>" readonly>
        <?php if($event): ?>
            <?php if(isset($event->thumbnail) && $event->thumbnail!=""): ?>
            <img src="<?php echo e(asset('storage/location/events/' . $event->thumbnail)); ?>" alt="Event Image" class="img-fluid w-100 " style="border-radius:5px;">
            <?php endif; ?>
            <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
            <?php endif; ?>
            <div class="container mt-4 center-content events-details-content">
                <h1><?php echo e(ucfirst($event->event_title)); ?></h1>
                <h3 ><?php echo e($event->formattedDate()); ?></h3>
                <!-- Name of Event Creator -->
                <h2><?php echo e($event->createdBy->fname.' '.$event->createdBy->lname); ?></h2>
                <!-- Edit and Share Buttons with Icons -->
                <div class="d-flex mb-3">
                    <?php if($layout=='sidebar'): ?>
                    <a class="btn section-btn me-1" href="<?php echo e(url('backend/events/'.$locationId.'/'.$event->event_id)); ?>" style="display:inline;" ><i class="bi bi-pencil-square"></i></a>
                    <?php endif; ?>
                    <button type="button" onclick="share(<?php echo e($event->event_id); ?>)" class="btn section-btn"><i class="bi bi-share-fill"></i></button>
                </div>
                <!-- User Icon and Responded Number -->
                <div class="d-flex align-items-center mt-3" style="padding-top:50px;">
                    <i class="bi bi-person-fill"></i>
                    <span class="ml-2" style="padding-left:15px;"><?php echo e($interestedCount); ?> User Interested</span>&nbsp;/&nbsp; 
                    <?php if($layout=='sidebar'): ?>
                    <!-- <a href="<?php echo e(url('backend/upcoming-guests/'.$event->event_id)); ?>" style="display:inline;" >View Guest List</a> -->
                    <a href="<?php echo e(url('backend/event-responded/'.$locationId.'/'.$event->event_id)); ?>" style="display:inline;" >View Guest List</a>
                    <?php endif; ?>
                </div>
                <!-- Calendar Icon and Event Date Time -->
                <div class="d-flex align-items-center mt-3">
                    <i class="bi bi-calendar"></i>
                    <span class="ml-2" style="padding-left:15px;"><?php echo e($event->formattedDate()); ?></span>
                </div>
                
                <div class="d-flex align-items-center mt-3">
                    <i class="bi bi-geo-alt-fill"></i>
                    <?php if($event->event_type=='online'): ?>
                    <span class="ml-2" style="padding-left:15px;">ONLINE</span>
                    <?php elseif($event->event_type=='location' && $event->address): ?>
                    <span class="ml-2" style="padding-left:15px;"><?php echo e($event->address); ?></span>
                    <?php endif; ?>
                </div>
                
                <!-- Ticket Icon and Ticket Price with Link -->
                <div class="d-flex align-items-center mt-3">
                <i class="bi bi-ticket-perforated"></i>
                    <span class="ml-2" style="padding-left:15px;"> <?php echo e($event->ticket_price); ?> Points</span>
                </div>
                <!-- Globe Icon and Event Type -->
                <div class="d-flex align-items-center mt-3">
                    <i class="bi bi-globe"></i>
                    <span class="ml-2" style="padding-left:15px;"><?php echo e($event->public_private); ?></span>
                </div>
                <!-- Event Description -->
                <div class="mt-3">
                    <?php echo $event->description; ?>

                </div>
                <!-- Participant Heading -->
                <h5 class="mt-4">Participants</h5>
                <!-- Interested and Going Buttons -->
                
                <!-- Interested button form -->
                <button type="button" style="width:250px;padding:19px" class="btn section-btn" <?php if(Auth::guest()): ?> disabled <?php elseif(isset($event->interested[0]->user_id)): ?> disabled <?php else: ?> onclick="event_action(this,<?php echo e($event->event_id); ?>,'interested')" <?php endif; ?>><span id="interested_count"><?php echo e($interestedCount); ?></span> </br>Interested <i class="bi bi-hand-thumbs-up"></i></button>

                <!-- Going button form -->
                <?php if($event->public_private=='public'): ?>
                <button type="button" style="width:250px;padding:19px" class="btn section-btn goingevent" data-event="<?php echo e($event->event_id); ?>" <?php if(Auth::guest()): ?> disabled <?php elseif(isset($event->going[0]->user_id)): ?> disabled <?php endif; ?>><span><?php if(!empty($event->ticket_price)): ?> <?php echo e($event->ticket_price); ?> Points <?php endif; ?></span></br> Going <i class="bi bi-arrow-right"></i></button>
                <?php endif; ?>

                <?php if(!is_null($event->playback_url)): ?>
                <div class="mt-4 mb-4" align="center" id="video-container" data-playback-url="<?php echo e($event->playback_url); ?>"></div>
                <?php endif; ?>

                <?php if($event->event_type=='location' && $event->address): ?>
                <h5 class="mt-4">Address</h5>
                <p><?php echo e($event->address); ?></p>
                <div class="row mt-5">
                    <div class="col-md-12">
                        <div class="mapouter">
                            <div class="gmap_canvas">
                                <iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=1324&amp;height=400&amp;hl=en&amp;q=<?php echo e($event->address); ?>&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                                <a href="https://connectionsgame.org/">Connections Unlimited</a>
                            </div><style>.mapouter{position:relative;text-align:right;width:100%;height:400px;}.gmap_canvas {overflow:hidden;background:none!important;width:100%;height:400px;}.gmap_iframe {height:400px!important;}</style>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <p>No event found.</p>
        <?php endif; ?>  
    </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<link href="https://vjs.zencdn.net/8.16.1/video-js.css" rel="stylesheet">
<script src="https://vjs.zencdn.net/8.16.1/video.min.js"></script>
<script>
// Initialize the video player using JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Create a video element
    var videoElement = document.createElement('video');
    videoElement.id = 'my-video';
    videoElement.className = 'video-js vjs-default-skin';
    videoElement.controls = true;
    videoElement.preload = 'auto';
    //videoElement.width = 600;
    //videoElement.height = 400;

    // Add the video element to the container
    document.getElementById('video-container').appendChild(videoElement);

    // Initialize Video.js player with HLS support
    var player = videojs(videoElement, {
        techOrder: ['html5'], // Use the native HTML5 video player
        html5: {
            hls: {
                withCredentials: false // Optional: whether to send cookies with HLS request
            }
        }
    });

    let playback_url = $('#video-container').data('playback-url');
    // Add HLS playback URL to the player
    player.src({
        type: 'application/x-mpegURL',
        src: playback_url
    });
});

$(document).ready(function(){
    
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.'.$layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/managing/event-detail.blade.php ENDPATH**/ ?>