
<?php $__env->startSection('title', 'Nomadic-Equipment Categories'); ?>
<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1 class="float-start">Equipment Categories</h1>
  <button type="button" class="btn float-end addicon"><i class="bi bi-plus"></i> Add New Category</button>
</div>

<section class="section profile">
  <div class="row">
    <div class="gridcard col-xl-12">

      <div class="card">
        <div class="row">
          <div class="col-md-7 mb-2 position-relative">
            <input id="search_field" type="text" class="form-control" placeholder="Search">
            <i class="bi bi-search searchicon"></i>
          </div>
        </div>
        <div class="card-body profile-card pt-4 pl-0 d-flex flex-column align-items-center">
          <table class="table">
            <thead>
              <tr>
                <td>Category</td>
                <td></td>
              </tr>
            </thead>
            <tbody>
              <?php if(!empty($data) && $data->count()): ?>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($dt->cat_name); ?></td>
                  <td>
                    <i class="bi bi-pencil editicon" data-uuid="<?php echo e($dt->id); ?>"></i>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>
                <td colspan="2">No record found</td>
              </tr>  
              <?php endif; ?>
            </tbody>
            <tfoot>
              <tr>
                <td colspan="2">
                  <div class="foot-paging">
                    <?php echo $data->withQueryString()->links('vendor.pagination.bootstrap-5'); ?>

                  </div>  
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

    </div>

    <div class="col-xl-5 user-card" style="display:none;">
      <div class="card thinborder" style="min-height:500px;">
        <div class="card-body pt-3">
        </div>
      </div>
    </div>

  </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script>
  $(document).ready(function () {
    $(document).on('click','.searchicon',function(){
      let user_search = $('#user_search').val();
      if($.trim(user_search)!=""){
        window.location.href = APP_URL+'/equip-categories?name='+user_search;
      }
    });

    $(document).on('click', '.addicon, .editicon', function(){
      $('.gridcard').removeClass('col-xl-12').addClass('col-xl-7');
      $('.user-card').show();
      $('.user-card .card-body').html('<div class="pt-5 d-flex justify-content-center"><div class="spinner-grow" role="status"></div></div>');
      
      let uuid = $(this).data('uuid');
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {_token:_token, lid:uuid,type:'edit'},
          url: APP_URL+"/equipcat-detail",
          success: function(res) {
            if(res.status){
              $('.user-card .card-body').html(res.content);
            }
          },
          error: function(res) {                    
            ajax_error(res);
          }
      });
    });
    
    $(document).on('click', '#btn_saveEqipCat', function(){
      let obj = $(this);
      obj.attr('disabled',true);
      $.ajax({
          type: 'POST',
          dataType: 'json',
          data: $('#updateEquipCat').serialize(),
          url: APP_URL+"/save-equipcat",
          success: function(res) {
            obj.attr('disabled',false);
            if(res.status){
              $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
              $('#alertMsg').modal('show');
            }
            window.location.reload();
          },
          error: function(res) {
            obj.attr('disabled',false);  
            ajax_error(res);
          }
      });
    });
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/global/equip-categories.blade.php ENDPATH**/ ?>