
<?php $__env->startSection('title', 'Review Booking'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Create something with us!')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/booking-banner.png')); ?>">
</div>

<section class="visible">
    <div class="container text-dark" data-aos="fade-up">
        <div class="row mt-3">
            <div class="col-md-12 text-center">
                <h5>Review your booking!</h5>
            </div>
        </div>
    </div>

    <h5 class="ps-3 mt-3">Details</h5>
    <div class="container text-dark" data-aos="fade-up">
        <div class="row mt-3">
            <h5>Location</h5>
            <div class="col-md-2">
                <img class="img-fluid w-100" src="<?php echo e(url('storage/location/'.$location->banner_picture)); ?>">
            </div>
            <div class="col-md-2"><?php echo e($location->location->location); ?></div>
        </div>

        <h5 class="mt-3">Date</h5>
        <div><?php echo e(date('d M, Y', strtotime($booking_form['start_date']))); ?> <?php echo e(date('g:i A',strtotime($booking_form['start_time']))); ?> - <?php echo e(date('d M, Y', strtotime($booking_form['end_date']))); ?> <?php echo e(date('g:i A',strtotime($booking_form['end_time']))); ?></div>

        <?php $total_cost = 0; ?>
        <?php if(!empty($studio)): ?>
            <h5 class="mt-3 fw-bold">Type of studio</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    <img class="img-fluid w-100" src="<?php echo e(url('storage/location/thumb_'.$studio->landingPage->banner_picture)); ?>">
                </div>
                <div class="col-md-3">
                    <h5><?php echo e($studio->name); ?></h5>
                    <div class="mt-3"><?php echo $studio->landingPage->description; ?></div>
                </div>
                <div class="col-md-3">
                    <?php if(isset($booking_points['studio'][$studio->id]['daily'])): ?>
                    <?php $__currentLoopData = $booking_points['studio'][$studio->id]['daily']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $daily): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($daily); ?>pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($daily); ?> pts</div>
                        </div>
                        <?php $total_cost += $daily; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if(isset($booking_points['studio'][$studio->id]['hourly'])): ?>
                        <?php $__currentLoopData = $booking_points['studio'][$studio->id]['hourly']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($hourly_points); ?>pts x <?php echo e($hourly_data[0]); ?>hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($hourly_data[1]); ?> pts</div>
                        </div>
                        <?php $total_cost += $hourly_data[1]; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if(!empty($equipment)): ?>
            <h5 class="mt-3 fw-bold">Equipment</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    <img class="img-fluid w-100" src="<?php echo e(url('storage/rental/'.$equipment->photo)); ?>">
                </div>
                <div class="col-md-3">
                    <h5><?php echo e($equipment->name); ?></h5>
                    <div class="mt-3"><?php echo $equipment->description; ?></div>
                </div>
                <div class="col-md-3">
                    <?php if(isset($booking_points['equipment'][$equipment->id]['daily'])): ?>
                    <?php $__currentLoopData = $booking_points['equipment'][$equipment->id]['daily']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $daily): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($daily); ?>pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($daily); ?> pts</div>
                            <?php $total_cost += $daily; ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if(isset($booking_points['equipment'][$equipment->id]['hourly'])): ?>
                        <?php $__currentLoopData = $booking_points['equipment'][$equipment->id]['hourly']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($hourly_points); ?>pts x <?php echo e($hourly_data[0]); ?>hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($hourly_data[1]); ?> pts</div>
                            <?php $total_cost += $hourly_data[1]; ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if(!empty($resource)): ?>
            <h5 class="mt-3 fw-bold">Additional Support</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    <img class="img-fluid w-100" src="<?php echo e(url('storage/location/thumb_'.$resource->profile_pic)); ?>">
                </div>
                <div class="col-md-3">
                    <h5><?php echo e($resource->fname); ?> <?php echo e($resource->lname); ?></h5>
                    <div class="mt-3"><?php echo $resource->description; ?></div>
                </div>
                <div class="col-md-3">
                    <?php if(isset($booking_points['resource'][$resource->id]['daily'])): ?>
                    <?php $__currentLoopData = $booking_points['resource'][$resource->id]['daily']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $daily): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($daily); ?>pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($daily); ?> pts</div>
                            <?php $total_cost += $daily; ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if(isset($booking_points['resource'][$resource->id]['hourly'])): ?>
                        <?php $__currentLoopData = $booking_points['resource'][$resource->id]['hourly']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($hourly_points); ?>pts x <?php echo e($hourly_data[0]); ?>hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($hourly_data[1]); ?> pts</div>
                        </div>
                        <?php $total_cost += $hourly_data[1]; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php $guest_amount = 0; ?>
        <?php if(session()->has('guests')): ?>
            <h5 class="mt-3 fw-bold">Additional Guest</h5>
            <?php $__currentLoopData = session()->get('guests'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $guest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="row mt-3">
                <div class="col-md-5">
                    <h5><?php echo e($guest['fname']); ?> <?php echo e($guest['lname']); ?> (<?php echo e($guest['email']); ?>)</h5>
                </div>
                <div class="col-md-3">
                    <?php if(($loop->index +1) > session()->get('free_guest')): ?>
                        <div class="row">
                            <div class="col-md-6 text-muted">Guest Fee</div>
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e(session()->get('additional_guest_points')); ?> pts</div>
                        </div>
                        <?php $guest_amount += session()->get('additional_guest_points'); ?>
                    <?php else: ?>
                        <div class="row">  
                            <div class="col-md-6 text-muted">Free Guest</div>
                            <div class="col-md-3 text-muted p-0 text-end">= 0 pts</div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <h5 class="mt-3 fw-bold">Add Guest</h5>
        <div class="row mt-3" id="guests_section">
            <div class="col-md-12">
                <form id="guests_form">
                    <div id="guests_list">
                        <!-- Guest rows will be appended here -->
                    </div>
                    <button type="button" class="btn btn-primary btn-sm mt-2" id="add_guest_btn">Add Guest</button>
                    <button type="submit" class="btn btn-success btn-sm mt-2 ms-2" id="save_guests_btn" style="display:none;">Save Guests</button>
                </form>
                <div id="guests_error" class="text-danger mt-2" style="display:none;"></div>
            </div>
        </div>

        <div class="row mt-5 pt-4 ps-4 pe-4" style="border-top:1px solid;">
            <div class="col-md-6"><h5>Booking cost</h5></div>
            <div class="col-md-6 text-end"><h5><?php echo e((int)$total_cost + (int)$guest_amount); ?> pts</h5></div>
        </div>

        <div class="row mt-4 mb-4">
            <div class="col-md-12 text-center">
                <a href="<?php echo e(url('booking-process')); ?>" class="btn btn-primary btndisb mb-2">Confirm Booking </a>
            </div>
        </div>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let guestIndex = 0;
    const guestsList = document.getElementById('guests_list');
    const addGuestBtn = document.getElementById('add_guest_btn');
    const saveGuestsBtn = document.getElementById('save_guests_btn');
    const guestsForm = document.getElementById('guests_form');
    const guestsError = document.getElementById('guests_error');

    function createGuestRow(index) {
        const row = document.createElement('div');
        row.className = 'row align-items-end mb-2 guest-row';
        row.innerHTML = `
            <div class="col-md-3 mb-1">
                <input type="text" name="guests[${index}][fname]" class="form-control guest-fname" placeholder="First Name" required>
            </div>
            <div class="col-md-3 mb-1">
                <input type="text" name="guests[${index}][lname]" class="form-control guest-lname" placeholder="Last Name" required>
            </div>
            <div class="col-md-4 mb-1">
                <input type="email" name="guests[${index}][email]" class="form-control guest-email" placeholder="Email" required>
            </div>
            <div class="col-md-2 mb-1 text-end">
                <button type="button" class="btn btn-danger btn-sm remove-guest-btn">Remove</button>
            </div>
        `;
        return row;
    }

    function updateSaveButtonVisibility() {
        const rows = guestsList.querySelectorAll('.guest-row');
        saveGuestsBtn.style.display = rows.length > 0 ? 'inline-block' : 'none';
        // Always show Add Guest button
        addGuestBtn.style.display = 'inline-block';
    }

    addGuestBtn.addEventListener('click', function() {
        const row = createGuestRow(guestIndex++);
        guestsList.appendChild(row);
        updateSaveButtonVisibility();
    });

    guestsList.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-guest-btn')) {
            e.target.closest('.guest-row').remove();
            updateSaveButtonVisibility();
        }
    });

    guestsForm.addEventListener('submit', function(e) {
        e.preventDefault();
        guestsError.style.display = 'none';
        let valid = true;
        let errorMsg = '';
        const rows = guestsList.querySelectorAll('.guest-row');
        let guests = [];
        if (rows.length === 0) {
            valid = false;
            errorMsg = 'Please add at least one guest.';
        } else {
            const emailRegex = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
            rows.forEach(function(row, idx) {
                const fname = row.querySelector('.guest-fname').value.trim();
                const lname = row.querySelector('.guest-lname').value.trim();
                const email = row.querySelector('.guest-email').value.trim();
                console.log(fname, lname, email);
                if (!fname || !lname || !email) {
                    valid = false;
                    errorMsg = 'All fields are required for each guest.';
                } else if (!emailRegex.test(email)) {
                    valid = false;
                    errorMsg = 'Please enter a valid email address for each guest.';
                } else {
                    guests.push({fname, lname, email});
                }
            });
        }
        if (!valid) {
            guestsError.textContent = errorMsg;
            guestsError.style.display = 'block';
            return;
        }
        // Save guests to session via AJAX
        fetch("<?php echo e(url('save-guests-session')); ?>", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({guests: guests})
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                window.location.reload();
            } else {
                guestsError.textContent = data.message || 'Failed to save guests.';
                guestsError.classList.remove('text-success');
                guestsError.classList.add('text-danger');
                guestsError.style.display = 'block';
            }
        })
        .catch(() => {
            guestsError.textContent = 'Failed to save guests.';
            guestsError.classList.remove('text-success');
            guestsError.classList.add('text-danger');
            guestsError.style.display = 'block';
        });
    });

    // Optionally, add one guest row by default
    // const row = createGuestRow(guestIndex++);
    // guestsList.appendChild(row);
    // updateSaveButtonVisibility();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/booking/review-booking.blade.php ENDPATH**/ ?>