<?php $__env->startSection('title', 'Nomadic-Events'); ?>
<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1><?php if(isset($events->event_id)): ?>Update <?php else: ?> Create new <?php endif; ?> event</h1>
</div>

<section class="section profile">

  <div class="col-xl-12">
    <input type="hidden" id="eventsid" name="eventsid" value="<?php if(isset($events->event_id)): ?><?php echo e($events->event_id); ?><?php endif; ?>" readonly>
    <input type="hidden" id="type" name="type" value="events" readonly>
    <input type="hidden" id="location_id" name="location_id" value="<?php echo e($locationId); ?>" readonly>

    <?php if(session('success')): ?>
    <div class="alert alert-success p-2"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Type</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <div>
                  <input id="checkbox-1" class="checkbox-custom" value="location" name="event_type" type="radio" <?php if(isset($events->event_type) && $events->event_type=='location'): ?> checked <?php endif; ?>>
                  <label for="checkbox-1" class="checkbox-custom-label">Location</label> 
                </div>
                <div>
                  <input id="checkbox-2" class="checkbox-custom" value="online" name="event_type" type="radio" <?php if(isset($events->event_type) && $events->event_type=='online'): ?> checked <?php endif; ?>>
                  <label for="checkbox-2" class="checkbox-custom-label">Online</label> 
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Public or Private</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <div>
                  <input id="checkbox-3" class="checkbox-custom" value="public" name="public_private" type="radio" <?php if(isset($events->public_private) && $events->public_private=='public'): ?> checked <?php endif; ?>>
                  <label for="checkbox-3" class="checkbox-custom-label">Public</label> 
                </div>
                <div>
                  <input id="checkbox-4" class="checkbox-custom" value="private" name="public_private" type="radio" <?php if(isset($events->public_private) && $events->public_private=='private'): ?> checked <?php endif; ?>>
                  <label for="checkbox-4" class="checkbox-custom-label">Private</label> 
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row stream-url">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Stream URL</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="stream_url" placeholder="Stream URL" value="<?php if(isset($events->stream_url)): ?><?php echo e($events->stream_url); ?><?php endif; ?>" disabled />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row stream-key">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Stream Key</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" placeholder="Stream Key" value="<?php if(isset($events->stream_key)): ?><?php echo e($events->stream_key); ?><?php endif; ?>" disabled />
              </div>
              <?php if(isset($events->stream_key)): ?>
              <div class="col-md-2">
                <a class="reset-key pointer" data-type="event" data-id="<?php echo e($events->event_id); ?>" data-num="">Reset Key</a>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Title</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="event_title" placeholder="Title" value="<?php if(isset($events->event_title)): ?><?php echo e($events->event_title); ?><?php endif; ?>" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Date and time</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-4 mb-2 position-relative">
                <input type="date" class="form-control" name="event_date" placeholder="Date" value="<?php if(isset($events->event_date)): ?><?php echo e($events->event_date); ?><?php endif; ?>" />
              </div>
              <div class="col-md-3 mb-2 position-relative">
                <input type="text" class="form-control timepicker" readonly name="event_time" placeholder="Time" value="<?php if(isset($events->event_time)): ?><?php echo e($events->event_time); ?><?php endif; ?>" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Duration (HH:MM)</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-4 mb-2 position-relative">
                <select class="form-control" name="event_hour">
                <option value="00" <?php if($hours=='00'): ?> selected <?php endif; ?>>00</option>
                  <option value="01" <?php if($hours=='01'): ?> selected <?php endif; ?>>01</option>
                  <option value="02" <?php if($hours=='02'): ?> selected <?php endif; ?>>02</option>
                  <option value="03" <?php if($hours=='03'): ?> selected <?php endif; ?>>03</option>
                  <option value="04" <?php if($hours=='04'): ?> selected <?php endif; ?>>04</option>
                  <option value="05" <?php if($hours=='05'): ?> selected <?php endif; ?>>05</option>
                  <option value="06" <?php if($hours=='06'): ?> selected <?php endif; ?>>06</option>
                  <option value="07" <?php if($hours=='07'): ?> selected <?php endif; ?>>07</option>
                  <option value="08" <?php if($hours=='08'): ?> selected <?php endif; ?>>08</option>
                  <option value="09" <?php if($hours=='09'): ?> selected <?php endif; ?>>09</option>
                  <option value="10" <?php if($hours=='10'): ?> selected <?php endif; ?>>10</option>
                  <option value="11" <?php if($hours=='11'): ?> selected <?php endif; ?>>11</option>
                  <option value="12" <?php if($hours=='12'): ?> selected <?php endif; ?>>12</option>
                </select>
                <i class="bi bi-caret-down-fill searchicon"></i>
              </div>
              <div class="col-md-3 mb-2 position-relative">
                <select class="form-control" name="event_minute">
                  <option value="00" <?php if($minutes=='00'): ?> selected <?php endif; ?>>00</option>
                  <option value="15" <?php if($minutes=='15'): ?> selected <?php endif; ?>>15</option>
                  <option value="30" <?php if($minutes=='30'): ?> selected <?php endif; ?>>30</option>
                  <option value="45" <?php if($minutes=='45'): ?> selected <?php endif; ?>>45</option>
                </select>
                <i class="bi bi-caret-down-fill searchicon"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Address</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="text" class="form-control" name="address" placeholder="Address" value="<?php if(isset($events->address)): ?><?php echo e($events->address); ?><?php endif; ?>" style="height:70px;"/>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Ticket Price (In Points)</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <input type="number" class="form-control" name="ticket_price" placeholder="0" value="<?php if(isset($events->ticket_price)): ?><?php echo e($events->ticket_price); ?><?php endif; ?>" />
              </div>
              <!-- <div class="col-md-5 mb-2 position-relative">
                <input type="text" class="form-control" name="ticket_url" placeholder="Ticket URL" value="<?php if(isset($events->ticket_url)): ?><?php echo e($events->ticket_url); ?><?php endif; ?>" />
              </div> -->
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Picture</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div id="dispthumbnailimg" class="mb-3">
          <?php if(isset($events->thumbnail) && $events->thumbnail!=""): ?>
          <img src="<?php echo e(asset('storage/location/events')); ?>/<?php echo e($events->thumbnail); ?>" class="img-fluid w-75" style="border-radius:5px;">
          <?php endif; ?>
        </div>
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="<?php echo e(url('fileupload')); ?>" method="post" enctype="multipart/form-data" id="thumbnail_picture" class="dropzone">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="image_type" value="thumbnail" readonly>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Description</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <textarea id="quill-editor-default" class="quill-editor-default" style="height:100px;"><?php if(isset($events->description)): ?><?php echo e($events->description); ?><?php endif; ?></textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="row mt-3">
      <div class="col-md-12 text-center">
        <input id="btn_saveevent" type="button" class="btn btn-primary mb-2 mt-4" value="Save event">
      </div>
    </div>

  </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script src="https://cdn.tiny.cloud/1/7oxmjjhuf38181ubsazv0hcwhi602g0gw8bbalyo8kvqttzl/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  tinyMCE.init({
    selector: 'textarea#quill-editor-default',
    plugins: 'anchor autolink link code',
    menubar: '',
    toolbar: 'bold italic underline link bullist code',
  });
</script>
<link href="<?php echo e(asset('css/dropzone.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('css/dropzone.custom.css')); ?>" rel="stylesheet">
<script src="<?php echo e(asset('js/dropzone.js')); ?>"></script>
<script src="<?php echo e(asset('js/cropper.js')); ?>"></script>
<link href="<?php echo e(asset('css/cropper.css')); ?>" rel="stylesheet">
<script>
  Dropzone.autoDiscover = false;
  var myDropzone = new Dropzone("#thumbnail_picture",{ 
      maxFiles: 1,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      transformFile: function(file, done) {
        let aRatio = 16/9;
        cropperImageFunc(file, done, this, aRatio, 1280, 720);
      }
  });
  myDropzone.on("sending", function(file, xhr, formData) {
    formData.append("type", $('#type').val());  
    formData.append("eventsid", $('#eventsid').val());
    formData.append("location_id", $('#location_id').val());
  });
  myDropzone.on("uploadprogress", function (file, progress) {
      $('.progress-text').html(parseInt(progress)+'%');
  });
  myDropzone.on("error", function (file, errorMessage) {
      $('.progress-text').html('0%').hide();
  });
  myDropzone.on("success", function (file, response) {
      $('.progress-text').html('0%').hide();
      $('#eventsid').val(response.eventsid);
      $('#dispthumbnailimg').html('<img src="'+APP_URL+'/'+response.imgurl+'" class="img-fluid w-75" style="border-radius:5px;">');
      myDropzone.removeAllFiles(true);
  });
   
  $(document).ready(function () {
    $(document).on('click','#btn_saveevent',function(){
      let eventsid = $('#eventsid').val();
      let location_id = $('#location_id').val();
      let event_type = $('input[name="event_type"]:checked').val();

      let public_private = $('input[name="public_private"]:checked').val();
      let stream_url = $('input[name="stream_url"]').val();
      let event_title = $('input[name="event_title"]').val();
      let event_date = $('input[name="event_date"]').val();
      let event_time = $('input[name="event_time"]').val();
      let address = $('input[name="address"]').val();
      let ticket_price = $('input[name="ticket_price"]').val();
      //let ticket_url = $('input[name="ticket_url"]').val();
      let event_hour = $('select[name="event_hour"]').val();
      let event_minute = $('select[name="event_minute"]').val();
      let duration = event_hour+':'+event_minute;
      let description = tinyMCE.get('quill-editor-default').getContent();
      
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, location_id:location_id, eventsid:eventsid, event_type:event_type, public_private:public_private, stream_url:stream_url, event_title:event_title, event_date:event_date, event_time:event_time, address:address, ticket_price:ticket_price, duration:duration, description:description},
        url: APP_URL+"/backend/save-events/"+location_id,
        success: function(res) {
          if(res.status){
            window.location.href = APP_URL+'/backend/events/'+location_id+'/'+res._id;
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/content-editing/events.blade.php ENDPATH**/ ?>