<header class="header">
  <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenu" aria-labelledby="offcanvasMenuLabel">
    <div class="offcanvas-header">
      <!-- <h5 class="offcanvas-title" id="offcanvasMenuLabel">Menu</h5> -->
      <button type="button" class="btn-close text-reset menu-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
      <ul class="nav flex-column mx-auto">
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('studios')); ?>">Studios</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('locations')); ?>">Locations</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('crew')); ?>">People</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('equipments')); ?>">Equipment</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('events')); ?>">Events</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('services')); ?>">Services</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('news')); ?>">News</a>
        </li>
      </ul>
      <!-- Language & Sign-up button -->
      <div class="navbar-sidecontainer-offcanvas">
        <?php if(Auth::guest()): ?>  
        <a class="btn-signup" href="<?php echo e(url('choose-your-plan')); ?>">Sign up <img src="<?php echo e(asset('images/arrow-up-right.62414968.svg')); ?>" alt="signup"></a>
        <a class="btn-signup" href="<?php echo e(url('login')); ?>">Sign in <img src="<?php echo e(asset('images/arrow-up-right.62414968.svg')); ?>" alt="signin"></a>
        <?php else: ?>
        <a class="btn-signup" href="<?php echo e(url('account-setting')); ?>">Account Setting<img src="<?php echo e(asset('images/arrow-up-right.62414968.svg')); ?>" alt="Account Setting"></a>
        
        <?php if(auth()->user()->role=='super-admin' || session()->has('page_access')): ?>  
        <a class="btn-signup" href="<?php echo e(url('backend/dashboard')); ?>"><?php echo e(__('Dashboard')); ?><img src="<?php echo e(asset('images/arrow-up-right.62414968.svg')); ?>" alt="Dashboard"></a>    
        <?php endif; ?>
        <a class="btn-signup" href="<?php echo e(route('logout')); ?>">Logout<img src="<?php echo e(asset('images/arrow-up-right.62414968.svg')); ?>" alt="Logout"></a>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <nav class="navbar navbar-expand-xl navbar-light fixed-top">
    <div class="container-fluid navbar-innercontainer">
      <!-- Navbar brand -->
      <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
        <!-- <img src="<?php echo e(asset('images/logo.bb83845b.svg')); ?>" alt="Nomadic Studio"> -->
        <img src="<?php echo e(asset('images/logob.png')); ?>" alt="Nomadic Studio" width="100" height="41">
      </a>

      <i class="bi bi-list toggle-sidebar-btn" style="display:none;"></i>

      <!-- Collapsible navigation links -->
      <div id="navbarNav" class="collapse navbar-collapse">
        <ul class="navbar-nav">
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('studios')); ?>"><?php echo e(__('Studios')); ?></a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('locations')); ?>"><?php echo e(__('Locations')); ?></a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('crew')); ?>"><?php echo e(__('People')); ?></a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('equipments')); ?>"><?php echo e(__('Equipment')); ?></a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('events')); ?>"><?php echo e(__('Events')); ?></a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('services')); ?>"><?php echo e(__('Services')); ?></a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('news')); ?>"><?php echo e(__('News')); ?></a>
          </li>
        </ul>
      </div>

      <!-- Language & Sign-up button -->
      <div class="navbar-sidecontainer">
        <!-- <a href="#" class="navbar-language" data-bs-toggle="modal" data-bs-target="#Languageandregion"><img src="<?php echo e(asset('images/globe.a123ec85.svg')); ?>" alt="globe"></a> -->
        <?php if(Auth::guest()): ?>
        <a class="btn btn-signup" href="<?php echo e(url('choose-your-plan')); ?>"><?php echo e(__('Sign up')); ?> <img src="<?php echo e(asset('images/arrow-up-right.62414968.svg')); ?>" alt="signup"></a>
        <a class="btn btn-signup" href="<?php echo e(url('login')); ?>"><?php echo e(__('Sign in')); ?> <img src="<?php echo e(asset('images/arrow-up-right.62414968.svg')); ?>" alt="signin"></a>
        <?php else: ?>
          <a href="#" class="navbar-language notificationBell" data-bs-toggle="dropdown">
            <?php if(session()->has('unread_noti') && session()->get('unread_noti') > 0): ?>  
            <img src="<?php echo e(asset('images/bell-notification.d984c52e.svg')); ?>" alt="notification">
            <?php else: ?>
            <img src="<?php echo e(asset('images/bell.173c56cd.svg')); ?>" alt="notification">
            <?php endif; ?>
          </a>
          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow notifications overflow-auto" style="max-height:600px"><?php echo $__env->make('notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></ul>
          
          <a href="<?php echo e(url('discuss')); ?>" class="navbar-language"><img src="<?php echo e(asset('images/message.9a99e419.svg')); ?>" alt="message"></a>
          <!-- <a href="#" class="navbar-language" style="display:none"><img src="<?php echo e(asset('images/message-notification.01bf09f1.svg')); ?>"></a> -->

          <a href="<?php echo e(url('account-setting')); ?>#booking-tab" class="navbar-language"><?php echo e(session()->get('point_balance')); ?> pts <img src="<?php echo e(asset('images/money-wallet.f0cf0e4d.svg')); ?>" alt="wallet"></a>
          
          <a href="#" class="" data-bs-toggle="dropdown">
            <?php if(is_null(auth()->user()->profile_pic)): ?>
            <!-- <i class="bi bi-person-circle" style="font-size: 35px;"></i> -->
            <img src="<?php echo e(asset('images/user-img.png')); ?>" alt="Profile" class="rounded-circle" width="35px">
            <?php else: ?>
            <img src="<?php echo e(url('/')); ?>/storage/profile-pic/<?php echo e(auth()->user()->profile_pic); ?>" alt="Profile" class="rounded-circle" width="38px" height="38px">
            <?php endif; ?>
          </a>
          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
            <li class="dropdown-header" style="text-align: left;">
              <h5 class="text-left"><?php echo e(auth()->user()->fname); ?> <?php echo e(auth()->user()->lname); ?></h5>
              <!-- <span>Web Designer</span> -->
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="<?php echo e(url('home')); ?>">
                <i class="bi bi-house"></i>
                <span><?php echo e(__('Home')); ?></span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <li>
              <a class="dropdown-item d-flex align-items-center" href="<?php echo e(url('account-setting')); ?>">
                <i class="bi bi-gear"></i>
                <span><?php echo e(__('Account Settings')); ?></span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <?php if(auth()->user()->role=='super-admin' || session()->has('page_access')): ?>  
            <li>
              <a class="dropdown-item d-flex align-items-center" href="<?php echo e(url('backend/dashboard')); ?>">
                <i class="bi bi-lock"></i>
                <span><?php echo e(__('Dashboard')); ?></span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>
            <?php endif; ?>
            <!-- <li>
              <a class="dropdown-item d-flex align-items-center" href="#">
                <i class="bi bi-question-circle"></i>
                <span>Need Help?</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li> -->

            <li>
              <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('logout')); ?>">
                <i class="bi bi-box-arrow-right"></i>
                <span><?php echo e(__('Sign Out')); ?></span>
              </a>
            </li>

          </ul>
        <?php endif; ?>
      </div>

      <button class="navbar-toggler float-end" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasMenu" aria-controls="offcanvasMenu" aria-label="offcanvasMenu" style="border:none;">
        <!-- <span class="navbar-toggler-icon"></span> -->
        <i class="bi bi-three-dots-vertical"></i>
      </button>
    </div>
  </nav>
</header><?php /**PATH /var/www/html/nomadic/resources/views/partials/header.blade.php ENDPATH**/ ?>