
<?php $__env->startSection('title', 'Nomadic Studios'); ?>
<?php $__env->startSection('content'); ?>
<div class="container" align="center">
  <div class="row w-75">
    <div class="card boxshadow">
      <div class="card-body pt-3">
        <div class="row">
          <div class="col-md-3 mb-2 position-relative">
            <div class="imgbox1">
              <?php if(!empty($data->profile_pic)): ?>
              <img src="<?php echo e(asset('storage/profile-pic')); ?>/<?php echo e($data->profile_pic); ?>" height="150">
              <?php else: ?>
              <img src="<?php echo e(asset('images/user-img.png')); ?>" height="150">
              <?php endif; ?>
            </div>
          </div>
          <div class="col-md-9 mb-2 position-relative overflow-auto">
            <table class="table table-borderless">
              <thead>
                <tr>
                  <td>Name</td>
                  <td>Email</td>
                  <td>Invitation Type</td>
                  <td>Invited By</td> 
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th><?php echo e(ucfirst($data->fname)); ?> <?php echo e(ucfirst($data->lname)); ?></th>
                  <th><?php echo e($data->email); ?></th>
                  <th><?php echo e(ucfirst($data->invitation_type)); ?></th>
                  <th><?php echo e($data->host->fname); ?> <?php echo e($data->host->lname); ?></th>
                </tr>
                <tr>
                  <td>Status</td>
                  <td>Event Name</td>  
                  <td>Date</td>
                  <td>Price</td>
                </tr>
                <tr>
                  <th>
                    <?php if(Auth::guest()): ?>
                      <a class="btn btn-dark w-100 mb-2" href="<?php echo e(url('login')); ?>">Login</a>
                    <?php else: ?>
                      <?php if($data->status==0): ?>
                      <input type="button" class="btn btn-dark goingevent w-100 mb-2" data-event="<?php echo e($event->event_id); ?>" data-guest="<?php echo e($data->id); ?>" value="Payment">
                      <?php elseif($data->status==1): ?>
                      <b>Checked In</b>
                      <?php elseif($data->status==2): ?>
                      <b>Cancelled</b>
                      <?php elseif($data->status==3): ?>
                      <b>Paid</b>
                      <?php endif; ?>
                    <?php endif; ?>
                  </th>
                  <th><?php echo e($event->event_title); ?></th>
                  <th><?php echo e(($event->event_date)); ?> <?php echo e(($event->event_time)); ?></th>
                  <th><?php echo e($event->ticket_price); ?> Points</th>
                </tr>
              </tbody>
            </table>
          </div>
        </div>        
      </div>
    </div>
  </div>
</div>
<!-- <div class="modal fade" id="otp_modal" style="display:none;z-index:10000;"></div> -->
<script>
  $(document).ready(function(){
    $(document).on('click', '.invaction', function(){ 
      let upcoming_id = $(this).data('guest');
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, upcoming_id:upcoming_id, status:1},
        url: APP_URL+"/invite-action",
        success: function(res) {
          if(res.status){
            window.location.reload();
          }else{
            $('#general_modal .modal-title').html('Recharge your wallet');
            $('#general_modal .modal-body').html(res.content);
            $('#general_modal').modal('show');
          }
        },
        error: function(res) {                    
          //ajax_error(res);
        }
      });
    });
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/guest/guest-detail.blade.php ENDPATH**/ ?>