
<?php $__env->startSection('title', 'Nomadic-News'); ?>
<?php $__env->startSection('content'); ?>
<div class="news-container dark-content">
  <section class="p-0">
    <div class="row content">
      <div class="video-image">
        <img class="img-fluid w-100" src="<?php echo e(asset('images/fe/news-sec-one.png')); ?>">
      </div>
    </div>
  </section>

  <section>
    <div class="container news-content" data-aos="fade-up">
        <div class="col-md-12">
          <div class="col-md-12 ps-3">
            <h2><?php echo e(__('Discover our news')); ?></h2>
            <div class="clearfx"></div>
            <div class="btn-group gap-2">
              <input type="date" id="txt_date" class="btn-outline-secondary2 txtcustom" value="<?php echo e(!empty(app('request')->filterDate) ? app('request')->filterDate : ''); ?>"/>
              <input type="text" id="txt_tags" class="btn-outline-secondary2 txtcustom" placeholder="Search By Tags" value="<?php echo e(!empty(app('request')->filterTags) ? app('request')->filterTags : ''); ?>"/>
            </div>
            <div class="clearfix"></div>
          </div>
          <div class="col-md-12 mt-4">
            <div class="container" data-aos="fade-up">
            <div class="row g-4">  
              <?php if($newsData->count() > 0): ?>
                <?php $classes = ['col-md-3','col-md-4', 'col-md-5']; ?>
                <?php $__currentLoopData = $newsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php $key = array_rand($classes); ?>
                  <div class="<?php echo e($classes[$key]); ?> news-card">
                    <div class="col-md-12 light-content boxshadow">
                      <a href="<?php echo e(url('view-news/'.$news->id)); ?>"><img src="<?php echo e(asset('storage/location/news/thumb_'.$news->banner)); ?>" class="p-0 news-image" /></a>
                      <div class="clearfix"></div>
                      <div class="box-inner-p">
                        <small class="mt-2 mb-2 d-block text-success"><?php echo e($news->tags); ?></small>
                        <div class="clearfix"></div>
                        <h3><?php echo e(\Illuminate\Support\Str::limit(ucfirst($news->name), 30, $end='..')); ?></h3>
                        <div class="clearfix"></div>
                        <p class="mb-2 d-block"><?php echo e(\Illuminate\Support\Str::limit($news->heading_intro, 30, $end='..')); ?></p>
                        <div class="clearfix"></div>
                        <div class="d-inline">
                          <?php if($news->createdBy->profile_pic): ?>
                          <img src="<?php echo e(asset('storage/profile-pic/'.$news->createdBy->profile_pic)); ?>" alt="Profile" class="rounded-circle height35">
                          <?php else: ?>
                          <img src="<?php echo e(asset('images/user-img.png')); ?>" alt="Profile" class="rounded-circle height35">
                          <?php endif; ?>
                        </div>
                        <div class="d-inline">
                          <span class="font13px" style="font-weight:100">
                          <?php echo e(ucfirst($news->createdBy->fname)); ?> <?php echo e(ucfirst($news->createdBy->lname)); ?>

                          </span>
                          <div class="font12px" style="margin-top:-15px;margin-left:40px">
                          <?php echo e(date('d l Y',strtotime($news->created_at))); ?>

                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
    </div>
  </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script>
$(document).ready(function () {
  // new filters
  var delayTimerNews;
  $(document).on('keyup','#txt_tags',function(){
    clearTimeout(delayTimerNews);
    delayTimerNews = setTimeout(() => news_filter(), 100)
  });
  $(document).on('change','#txt_date',function(){
    news_filter();
  });
});
function news_filter(){
  let txt_date = $('#txt_date').val();
  let txt_tags = $('#txt_tags').val();
  let url_filter = [];
  if(txt_date!=""){
    url_filter.push('filterDate='+txt_date);
  }
  if(txt_tags!=""){
    url_filter.push('filterTags='+txt_tags);
  }
  if(url_filter.length>0){
    let filter = url_filter.join('&');
    window.location.href = APP_URL+'/news?'+filter;
  }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/news/news.blade.php ENDPATH**/ ?>