
<?php $__env->startSection('title', 'Nomadic-OTP Verification'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Join global creatives')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/banner1.png')); ?>">
</div>

<div class="container" data-aos="fade-up">
    <h2 class="sub-head mt-4 mb-4"><?php echo e(__('Confirm your phone number')); ?></h2>
    <span><?php echo e(__('Please input 6-digit code we just sent to')); ?> +*(***)*** <?php echo e($mobile); ?>, <?php echo e(__('wrong phone number')); ?> <a class="anc-color" href="<?php echo e(url('login')); ?>"><?php echo e(__('Contact us')); ?></a>.</span>
    
    <div class="alert alert-danger errorMsgUpdt" style="display:none;"></div>
    <form id="otpForm" class="w-100">
        <?php echo csrf_field(); ?>
        <input type="hidden" id="mobile_number" value="<?php echo e($amob); ?>" readonly>
        <div class="row mb-5 mt-4 d-block"  align="center">
            <div class="col-md-4">
                <div id="otp" class="inputs d-flex flex-row justify-content-center mt-2">
                    <input class="m-2 text-center form-control rounded otp-input" type="text" id="first" name="first" maxlength="1" />
                    <input class="m-2 text-center form-control rounded otp-input" type="text" id="second" name="second" maxlength="1" />
                    <input class="m-2 text-center form-control rounded otp-input" type="text" id="third" name="third" maxlength="1" />
                    <input class="m-2 text-center form-control rounded otp-input" type="text" id="fourth" name="fourth" maxlength="1" />
                    <input class="m-2 text-center form-control rounded otp-input" type="text" id="fifth" name="fifth" maxlength="1" />
                    <input class="m-2 text-center form-control rounded otp-input" type="text" id="sixth" name="sixth" maxlength="1" />
                </div>
                <div class="form-container">
                    <span><?php echo e(__('Didn’t get an SMS?')); ?></span> <a data-type="mobile" class="send-otp pointer anc-color"><?php echo e(__('Send again')); ?></a>
                </div>
            </div>
        </div>
        <div class="row mb-5 mt-4 d-block"  align="center">
            <div class="col-md-4">
                <div class="form-container">
                    <div class="btnconter mt-3 mb-4">
                        <button class="btn btn-primary" type="button" id="btn_otpverify"><?php echo e(__('Submit')); ?>

                            <div class="spinner-border text-primary spinner" role="status" style="display:none;vertical-align:text-top;"><span class="visually-hidden"><?php echo e(__('Loading')); ?>...</span></div>
                        </button>
                    </div>
                    <span><?php echo e(__('Already have an account?')); ?></span> <a class="anc-color" href="<?php echo e(url('login')); ?>"><?php echo e(__('Login')); ?></a>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function(event) {
    OTPInput(); 
});
$(document).ready(function () {
    $(document).on('click','#btn_otpverify',function(){
        if($('#otpForm').valid()){
            $('#btn_otpverify .spinner').show();
            $.ajax({
                type: 'POST',
                dataType: 'json',
                data: $('#otpForm').serialize(),
                url: APP_URL+"/signup-save",
                success: function(res) {
                    $('#btn_otpverify .spinner').hide();
                    if(res.status){
                        window.location.href = APP_URL+'/profile-picture';
                    }
                },
                error: function(res) {                    
                    $('#btn_otpverify .spinner').hide();
                    ajax_error(res);
                }
            });
        }
    });

    $(document).on('click','.send-otp',function(){
        let otpfield;
        let type = $(this).data('type');
        otpfield = $('#mobile_number').val();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: {_token:_token, type:type, otpfield:otpfield},
            url: APP_URL+"/send-otp",
            success: function(res) {
                if(res.status){
                    $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
                    $('#alertMsg').modal('show');
                }
            },
            error: function(res) {
                ajax_error(res);
            }
        });
    });

    $('#otpForm').validate({
        rules: {
            first: {
                required: true,
            },
            second: {
                required: true
            },
            third: {
                required: true
            },
            fourth: {
                required: true
            },
            fifth: {
                required: true
            },
            sixth: {
                required: true
            }
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback float-start');
            element.closest('.rounded').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/auth/otp-verification.blade.php ENDPATH**/ ?>