
<?php $__env->startSection('title', 'Nomadic - Live'); ?>
<?php $__env->startSection('content'); ?>
<section class="visible">
  <div class="container mt-4">

    <div class="card" style="border:none !important;">
      <div class="row g-0">
        <div class="col-12 col-lg-5 col-xl-3">
          <div class="py-4 px-4 border-bottom">
            <div class="d-flex align-items-center py-1"><strong>Live Channels</strong></div>
          </div>
          <div>
              <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="d-flex justify-content-center mt-5">
              <a class="list-group-item list-group-item-action border-0 pointer live-channel" data-title="<?php echo e($loc->location); ?>" data-url="<?php echo e($loc->playbackurl1); ?>" data-id="<?php echo e($loc->id); ?>">
                <div class="d-flex align-items-start">
                    <img src="<?php echo e(asset('storage/location/'.$loc->landing_page->banner_picture)); ?>" class="rounded-circle mr-1 loc-pic-<?php echo e($loc->id); ?>" alt="<?php echo e($loc->location); ?>" width="40" height="40">
                    <div class="flex-grow-1 ms-2 mt-2 name"><?php echo e($loc->location); ?> 1</div>
                </div>
              </a>
              </div>
              <div class="d-flex justify-content-center mt-5">
              <a class="list-group-item list-group-item-action border-0 pointer live-channel" data-title="<?php echo e($loc->location); ?>" data-url="<?php echo e($loc->playbackurl2); ?>" data-id="<?php echo e($loc->id); ?>">
                <div class="d-flex align-items-start">
                    <img src="<?php echo e(asset('storage/location/'.$loc->landing_page->banner_picture)); ?>" class="rounded-circle mr-1 loc-pic-<?php echo e($loc->id); ?>" alt="<?php echo e($loc->location); ?>" width="40" height="40">
                    <div class="flex-grow-1 ms-2 mt-2 name"><?php echo e($loc->location); ?> 2</div>
                </div>
              </a>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
          <hr class="d-block d-lg-none mt-1 mb-0">
        </div>
        <div class="col-12 col-lg-7 col-xl-9" style="border-left:var(--bs-border-width) var(--bs-border-style) var(--bs-border-color)!important;">
          <div class="py-2 px-4 border-bottom d-none d-lg-block" style="min-height:60px;">
            <div class="d-flex align-items-center py-1">
              <div class="position-relative">
              <span id="loc_pic"></span>
              </div>
              <div class="flex-grow-1 ps-3">
                <strong class="loc-title"></strong>
              </div>
            </div>
          </div>
          <div id="chat_data">
            <div class="position-relative">
              <div id="video-container" class="p-4" style="text-align:center;min-height:300px">
                <b>Select live channel to view..</b>
              </div>
              <h4 class="loc-title ps-4"></h4>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<link href="https://vjs.zencdn.net/8.16.1/video-js.css" rel="stylesheet">
<script src="https://vjs.zencdn.net/8.16.1/video.min.js"></script>
<script>
$(document).ready(function(){
    $(document).on('click', '.live-channel', function(){
        let id = $(this).data('id');
        let title = $(this).data('title');
        let image_src = $('.loc-pic-'+id).attr('src');
        console.log(image_src);
        let playback_url = $(this).data('url');
        $('.loc-title').html(title);
        $('#loc_pic').html('<img src="'+image_src+'" class="rounded-circle mr-1 loc-pic-<?php echo e($loc->id); ?>" alt="<?php echo e($loc->location); ?>" width="40" height="40">');
        // Create a video element
        var videoElement = document.createElement('video');
        videoElement.id = 'my-video';
        videoElement.className = 'video-js vjs-default-skin';
        videoElement.controls = true;
        videoElement.preload = 'auto';
        //videoElement.width = 600;
        //videoElement.height = 400;

        // Add the video element to the container
        $('#video-container').html(videoElement);

        // Initialize Video.js player with HLS support
        var player = videojs(videoElement, {
            techOrder: ['html5'], // Use the native HTML5 video player
            html5: {
                hls: {
                    withCredentials: false // Optional: whether to send cookies with HLS request
                }
            }
        });

        // Add HLS playback URL to the player
        player.src({
            type: 'application/x-mpegURL',
            src: playback_url
        });
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/locations/live.blade.php ENDPATH**/ ?>