
<?php $__env->startSection('title', 'Booking | Select Resource'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Create something with us!')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/booking-banner.png')); ?>">
</div>

<section class="visible">
    <div class="container text-dark mt-3" data-aos="fade-up">
        <?php if(session('error')): ?>
        <div class="row"><div class="alert alert-danger"><?php echo e(session('error')); ?></div></div>
        <?php endif; ?>
        <div class="row">
            <div class="col-md-8">
                <?php if($resources->count() > 0): ?>
                <h2 class="mb-4">Select additional support</h2>
                <?php $__currentLoopData = $resources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row col-md-12 mt-3 <?php if(!$resource->available): ?> text-muted <?php endif; ?>">
                    <div class="col-md-1">
                        <div>
                            <input id="checkbox-<?php echo e($loop->index); ?>" class="checkbox-custom" value="<?php echo e($resource->id); ?>" name="booking_resource" type="radio" data-type="resource" data-days="<?php echo e($resource->booking_days); ?>" data-hours="<?php echo e($resource->booking_hours); ?>" <?php if(session()->has('temp-booking-resource-selection') && session()->get('temp-booking-resource-selection')==$resource->id): ?>checked <?php endif; ?> <?php if(!$resource->available): ?> disabled <?php endif; ?>>
                            <label for="checkbox-<?php echo e($loop->index); ?>" class="checkbox-custom-label"></label>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <h3><?php echo e($resource->fname); ?> <?php echo e($resource->lname); ?></h3>
                        <?php if(isset($resource->resourceName->name)): ?><h5 class="txtgray"><?php echo e($resource->resourceName->name); ?></h5><?php endif; ?>
                        <?php if($resource->description): ?>
                        <b>Description</b>
                        <div class="mt-2"><?php echo e($resource->description); ?></div>
                        <?php endif; ?>
                        <?php if(!$resource->available): ?>
                        <p>resource is booked at this time please select different time. <span class="text-primary pointer check-availability">check availability</span></p>
                        <div class="availability-calendar" data-id="<?php echo e($resource->id); ?>" data-type="resource"></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-2">
                        <h3><?php echo e($resource->resource_points); ?>pts</h3>
                    </div>
                    <div class="col-md-4">
                        <div class="imgbox">
                            <?php if($resource->profile_pic): ?>
                            <img src="<?php echo e(url('storage/profile-pic/'.$resource->profile_pic)); ?>" class="imgfluidlogged <?php if(!$resource->available): ?> opacity-50 <?php endif; ?>" />
                            <?php else: ?>
                            <img src="<?php echo e(url('images/user-img.png')); ?>" class="imgfluidlogged <?php if(!$resource->available): ?> opacity-50 <?php endif; ?>" />
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="row col-md-12 mt-5">
                    <div class="foot-paging">
                    <?php echo $resources->withQueryString()->links('vendor.pagination.bootstrap-5'); ?>

                    </div>
                </div>
                <?php else: ?>
                <h2 class="mt-4">Resources are not available this time.</h2>
                <?php endif; ?>
            </div>
            <div class="col-md-4 p-0">
                <?php echo $__env->make('frontend.booking.booking-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script>
    $(document).ready(function () {
        
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/booking/resource.blade.php ENDPATH**/ ?>