
<?php $__env->startSection('title', 'Nomadic-Events'); ?>
<?php $__env->startSection('content'); ?>

<div class="events-container">
  
  <section class="p-0 events-hero">
    <div class="row content">
      <div class="video-image">
        <img class="img-fluid w-100" src="<?php echo e(asset('images/fe/event-sec-one.png')); ?>">
        <h1><?php echo e(__('Events')); ?></h1>
      </div>
    </div>
  </section>

  <section class="events-list light-content">
    <div class="container" data-aos="fade-up">
      <div class="row">
        <div class="col-md-12">
          <div class="container">
            <div class="row">
              <div class="col-md-7 mx-auto">
                <h2><?php echo e(__('Discover events')); ?></h2>
                <div class="clearfx"></div>
                <div class="btn-group gap-2">
                  <select class="btn-outline-secondary2 txtcustom" id="txt_location">
                    <option value="">Location</option>
                    <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key); ?>" <?php echo e(!empty(app('request')->filterLocation && app('request')->filterLocation==$key) ? 'selected' : ''); ?>><?php echo e($val); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                  <input type="date" id="txt_date" class="btn-outline-secondary2 txtcustom" value="<?php echo e(!empty(app('request')->filterDate) ? app('request')->filterDate : ''); ?>"/>
                </div>
                <div class="clearfix"></div>
              </div>
            </div>
          </div>
          <div class="col-md-7 mx-auto">
            <div class="container" data-aos="fade-up">
            <?php if($events->count() > 0): ?>
              <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="row mt-5">
                <div class="col-md-12">
                  <a href="<?php echo e(url('view-event/'.$event->event_id)); ?>"><img src="<?php echo e(asset('storage/location/events/thumb_'.$event->thumbnail)); ?>" class="img-thumbnail p-0 imgshadow"></a>
                  <div class="clearfix"></div>
                  <p class="mt-2 mb-2 d-block font13px">
                  <?php echo e(date('l, d M',strtotime($event->event_date))); ?> AT <?php echo e(date('h:i A',strtotime($event->event_time))); ?>

                  </p>
                  <h2><?php echo e(ucfirst($event->event_title)); ?></h2>

                  <?php if($event->event_type=='online'): ?>
                  <p class="mt-2 mb-2 d-block font13px" style="text-transform: uppercase;"><?php echo e($event->event_type); ?></p>
                  <?php endif; ?>
                  <?php if($event->event_type=='location' && $event->address!=''): ?>
                  <p class="mt-2 mb-2 d-block font13px" style="text-transform: uppercase;"><?php echo e($event->address); ?></p>
                  <?php endif; ?>
                  <div class="small">
                    <span><?php echo e($event->interested_count); ?></span> interested - <span><?php echo e($event->going_count); ?></span> going
                  </div>
                  <div class="row mt-3">
                    <div class="col-md-5 d-grid">
                      <button type="button" class="btn btn-primary section-btn" <?php if(Auth::guest()): ?> disabled <?php elseif(isset($event->interested[0]->user_id)): ?> disabled <?php else: ?> onclick="event_action(this,<?php echo e($event->event_id); ?>,'interested')" <?php endif; ?>> Interested <i class="bi bi-hand-thumbs-up"></i></button>
                    </div>
                    <?php if($event->public_private=='public'): ?>
                    <div class="col-md-5 d-grid">
                      <button type="button" class="btn btn-primary section-btn goingevent" data-event="<?php echo e($event->event_id); ?>" <?php if(Auth::guest()): ?> disabled <?php elseif(isset($event->going[0]->user_id)): ?> disabled <?php endif; ?>><span><?php if(!empty($event->ticket_price)): ?> <?php echo e($event->ticket_price); ?> Points <?php endif; ?></span></br> Going <i class="bi bi-arrow-right"></i></button>
                    </div>
                    <?php endif; ?>
                    <div class="col-md-2 d-grid">
                      <button type="button" class="btn section-btn" onclick="share(<?php echo e($event->event_id); ?>)"><i class="bi bi-share"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<script>
$(document).ready(function () {
  // events filters
  $(document).on('change','#txt_date, #txt_location',function(){
    events_filter();
  });
});
function events_filter(){
  let txt_date = $('#txt_date').val();
  let txt_location = $('#txt_location').val();
  let url_filter = [];
  if(txt_date!=""){
    url_filter.push('filterDate='+txt_date);
  }
  if(txt_location!=""){
    url_filter.push('filterLocation='+txt_location);
  }
  if(url_filter.length>0){
    let filter = url_filter.join('&');
    window.location.href = APP_URL+'/events?'+filter;
  }else{
    window.location.href = APP_URL+'/events';
  }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/event/events.blade.php ENDPATH**/ ?>