
<?php $__env->startSection('title', 'Booking | Select studio'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Create something with us!')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/booking-banner.png')); ?>">
</div>

<section class="visible">
    <div class="container text-dark" data-aos="fade-up">
        <div class="row">
            <div class="col-md-12">
                <img class="img-fluid w-100" src="<?php echo e(asset('images/booking-image.png')); ?>">
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-12 text-center">
                <h5>Congratulations!</br></br>Your booking is confirmed.</h5>
            </div>
        </div>
    </div>

    <h5 class="ps-3 mt-3">Details</h5>
    <div class="container text-dark" data-aos="fade-up">
        <div class="row mt-3">
            <h5>Location</h5> 
            <div class="col-md-2">
                <img class="img-fluid w-100" src="<?php echo e(url('storage/location/'.$booking->banner_picture)); ?>">
            </div>
            <div class="col-md-2"><?php echo e($booking->location); ?></div>
        </div>

        <h5 class="mt-3">Date</h5>
        <div><?php echo e(date('d M, Y', strtotime($booking->start_date))); ?> <?php echo e(date('g:i A',strtotime($booking->start_time))); ?> - <?php echo e(date('d M, Y', strtotime($booking->end_date))); ?> <?php echo e(date('g:i A',strtotime($booking->end_time))); ?></div>

        <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($book->type=='studio'): ?>
            <h5 class="mt-3">Type of studio</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    <img class="img-fluid w-100" src="<?php echo e(url('storage/location/thumb_'.$studio->landingPage->banner_picture)); ?>">
                </div>
                <div class="col-md-3">
                    <h5><?php echo e($studio->name); ?></h5>
                    <div class="mt-3"><?php echo $studio->landingPage->description; ?></div>
                </div>
                <div class="col-md-3">
                    <?php $data = json_decode($book->data) ?>
                    <?php if(isset($data->daily)): ?>
                        <?php $__currentLoopData = $data->daily; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $daily): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($daily); ?>pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($daily); ?> pts</div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if(isset($data->hourly)): ?>
                        <?php $__currentLoopData = $data->hourly; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($hourly_points); ?>pts x <?php echo e($hourly_data[0]); ?>hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($hourly_data[1]); ?> pts</div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if($book->type=='rental'): ?>
            <h5 class="mt-3">Equipment</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    <img class="img-fluid w-100" src="<?php echo e(url('storage/rental/'.$equipment->photo)); ?>">
                </div>
                <div class="col-md-3">
                    <h5><?php echo e($equipment->name); ?></h5>
                    <div class="mt-3"><?php echo $equipment->description; ?></div>
                </div>
                <div class="col-md-3">
                    <?php $data = json_decode($book->data) ?>
                    <?php if(isset($data->daily)): ?>
                        <?php $__currentLoopData = $data->daily; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $daily): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($daily); ?>pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($daily); ?> pts</div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if(isset($data->hourly)): ?>
                        <?php $__currentLoopData = $data->hourly; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($hourly_points); ?>pts x <?php echo e($hourly_data[0]); ?>hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($hourly_data[1]); ?> pts</div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if($book->type=='resource'): ?>
            <h5 class="mt-3">Additional support</h5>
            <div class="row mt-3">
                <div class="col-md-2">
                    <?php if(is_null($resource->profile_pic)): ?>
                    <img class="img-fluid w-100" src="<?php echo e(asset('images/user-img.png')); ?>">
                    <?php else: ?>
                    <img class="img-fluid w-100" src="<?php echo e(url('storage/profile-pic/'.$resource->profile_pic)); ?>">
                    <?php endif; ?>
                </div>
                <div class="col-md-3">
                    <h5><?php echo e($resource->fname); ?> <?php echo e($resource->lname); ?></h5>
                    <?php if(isset($resource->resourceName->name)): ?><h5 class="txtgray"><?php echo e($resource->resourceName->name); ?></h5><?php endif; ?>
                    <div class="mt-3"><?php echo $resource->description; ?></div>
                </div>
                <div class="col-md-3">
                    <?php $data = json_decode($book->data) ?>
                    <?php if(isset($data->daily)): ?>
                        <?php $__currentLoopData = $data->daily; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $daily): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($daily); ?>pts x 1day </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($daily); ?> pts</div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php if(isset($data->hourly)): ?>
                        <?php $__currentLoopData = $data->hourly; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $hourly_data = explode('|',$hr);
                        $hourly_points = $hourly_data[1]/$hourly_data[0];
                        ?>
                        <div class="row">
                            <div class="col-md-6 text-muted"><?php echo e($hourly_points); ?>pts x <?php echo e($hourly_data[0]); ?>hours </div> 
                            <div class="col-md-3 text-muted p-0 text-end">= <?php echo e($hourly_data[1]); ?> pts</div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <div class="row mt-5 pt-4 ps-4 pe-4" style="border-top:1px solid;">
            <div class="col-md-6"><h5>Booking cost</h5></div>
            <div class="col-md-6 text-end"><h5><?php echo e($booking->total_points); ?> pts</h5></div>
        </div>
        <div class="row mt-3 ps-4 pe-4">
            <div class="col-md-6"><h5>Points left</h5></div>
            <div class="col-md-6 text-end"><h5><?php echo e(session()->get('point_balance')); ?> pts</h5></div>
        </div>

        <div class="row mt-4 mb-4">
            <div id="cancl_book_cont" class="col-md-12 text-center">
                <?php if($booking->status==0): ?>
                    <?php $booking_time = strtotime($booking->end_date.' '.$booking->end_time); ?>
                    <?php if(time() > $booking_time): ?>
                    <b>Not marked as complete</b>
                    <?php else: ?>
                        <a class="btn btn-dark w-30 me-5" href="<?php echo e(url('invite-guest/booking/'.$bookingId)); ?>"> Invite guest</a>
                        <input type="button" class="btn btn-danger w-30 cancel-booking" data-booking="<?php echo e($bookingId); ?>" value="Cancel booking" />
                    <?php endif; ?>
                <?php elseif($booking->status==1): ?> <b>Booking Completed</b>
                <?php elseif($booking->status==2): ?> <b>Booking Cancelled</b>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/booking/booking-confirmed.blade.php ENDPATH**/ ?>