
<?php $__env->startSection('title', 'Nomadic Studios | Add Payment Method'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Join global creatives')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/banner1.png')); ?>">
</div>

<div class="container">
    <h2 class="mt-4"><?php echo e(__('Add payment method')); ?></h2>
    <div class="row mb-5 d-block" align="center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="alert alert-danger p-2 errorMsgUpdt" style="display:none;"></div>
                    <form id="payment-form" action="<?php echo e(url('add-payment-method-process')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="text" name="name" id="card-holder-name" class="form-control" value="" placeholder="<?php echo e(__('Name on the card')); ?>">
                                </div>
                            </div>
                        </div>
  
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div id="card-element"></div>
                                </div>
                            </div>
                            <div class="col-md-12 mt-4">
                                <button type="submit" class="btn btn-primary" id="card-button" data-secret="<?php echo e($intent->client_secret); ?>"><?php echo e(__('Add your card')); ?></button>
                            </div>
                        </div>
  
                    </form>
  
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script src="https://js.stripe.com/v3/"></script>
<script>
    const stripe = Stripe("<?php echo e(env('STRIPE_KEY')); ?>")
  
    const elements = stripe.elements()
    const cardElement = elements.create('card')
  
    cardElement.mount('#card-element')
  
    const form = document.getElementById('payment-form')
    const cardBtn = document.getElementById('card-button')
    const cardHolderName = document.getElementById('card-holder-name')
  
    form.addEventListener('submit', async (e) => {
        e.preventDefault()
        let fullname = $('#card-holder-name').val();
        if($.trim(fullname)==""){
            $('.errorMsgUpdt').html("<?php echo e(__('Name is required field.')); ?>").show();
            return false;
        }
        
        cardBtn.disabled = true
        const { setupIntent, error } = await stripe.confirmCardSetup(
            cardBtn.dataset.secret, {
                payment_method: {
                    card: cardElement,
                    billing_details: {
                        name: cardHolderName.value
                    }   
                }
            }
        )
  
        if(error) {
            console.log(error);
            $('.errorMsgUpdt').html(error.message).show();
            $('#card-button').removeAttr('disabled');
        } else {
            $('.errorMsgUpdt').html('').hide();
            let token = document.createElement('input')
            token.setAttribute('type', 'hidden')
            token.setAttribute('name', 'token')
            token.setAttribute('value', setupIntent.payment_method)
            form.appendChild(token)
            form.submit();
        }
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/stripe/add-payment-method.blade.php ENDPATH**/ ?>