<?php if($data): ?>
<div class="row">
  <div class="col-md-7">
    <?php if($data->profile_pic): ?>
    <img src="<?php echo e(asset('storage/profile-pic')); ?>/<?php echo e($data->profile_pic); ?>" class="img-fluid" style="height:100%;">
    <?php else: ?>
    <img src="<?php echo e(asset('images/user-img.png')); ?>" class="img-fluid" style="height:100%;">
    <?php endif; ?>
  </div>
  <div class="col-md-5">
    <label class="small text-muted">Name</label>
    <div class="clearboth"></div>
    <label class="small text-muted">
     <b> <?php if($data->fname): ?><?php echo e(ucfirst($data->fname)); ?> <?php echo e(ucfirst($data->lname)); ?><?php endif; ?></b>
    </label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Email</label>
    <div class="clearboth"></div>
    <label class="small text-muted word-wrap"><?php if(isset($data->email)): ?><b><?php echo e($data->email); ?></b><?php endif; ?></label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Phone</label>
    <div class="clearboth"></div>
    <label class="small text-muted"><?php if(isset($data->mobile_number)): ?><b><?php echo e($data->mobile_number); ?></b><?php endif; ?></label>
  </div>
</div>
<div class="row">
  <div class="col-md-12 mt-3">
    <label class="small text-muted"><b>Bio</b></label>
    <div class="clearboth"></div>
    <label  class="small text-muted mt-3"><?php if(isset($data->description)): ?><?php echo e($data->description); ?><?php endif; ?></label>
    <?php if(isset($data->address)): ?>
    <label class="small text-muted"><b>Address</b></label>
    <div class="clearboth"></div>
    <label  class="small text-muted mt-3"><?php echo e($data->address); ?></label>
    <div class="clearboth"></div>
    <?php endif; ?>
    <?php if(isset($data->profile_link)): ?>
    <label class="small text-muted"><b>Links</b></label>
    <div class="clearboth"></div>
    <label  class="small text-muted mt-3"><?php echo e($data->profile_link); ?></label>
    <div class="clearboth"></div>
    <?php endif; ?>
    <?php if(isset($data->instagram_link)): ?>
    <label  class="small text-muted mt-3"><?php echo e($data->instagram_link); ?></label>
    <div class="clearboth"></div>
    <?php endif; ?>
    <?php if(isset($data->facebook_link)): ?>
    <label  class="small text-muted mt-3"><?php echo e($data->facebook_link); ?></label>
    <div class="clearboth"></div>
    <?php endif; ?>
    <?php if(isset($data->twitter_link)): ?>
    <label class="small text-muted mt-3"><?php echo e($data->twitter_link); ?></label>
    <div class="clearboth"></div>
    <?php endif; ?>

    <form id="updateTeam">
      <?php echo csrf_field(); ?>
      <input type="hidden" id="user_uuid" name="user_uuid" value="<?php echo e($data->uuid); ?>" readonly>
      <input type="hidden" id="userID" name="userID" value="<?php echo e($data->id); ?>" readonly>

      <div class="clearboth"></div>
      <label class="small text-muted mt-4"><b>Assign Role</b></label>
      <div class="clearboth"></div>
      <div class="row mb-2">
        <div class="col-md-10 position-relative">
        <input type="hidden" name="locationId" value="<?php echo e($locationId); ?>" />
        <select class="form-control" name="role" data-done-button="true" multiple></select>
        </div>
      </div>
      
      <div class="clearboth"></div>
      <label class="small text-muted mt-4"><b>Equipment Specialist</b></label>
      <div class="clearboth"></div>
      <div class="row mb-2">
        <div class="col-md-10 position-relative">
        <select class="form-control" name="specialist" data-done-button="true" multiple></select>
        </div>
      </div>

      <div class="clearboth"></div>
      <label  class="small text-muted mt-4" for="daily_rate"><b>Daily Rate (<?php echo e(session()->get('user_currency')); ?>)</b></label>
      <div class="clearboth"></div>  
      <div class="row mb-2">
        <div class="col-md-10 position-relative"> 
          <input type="number" name="daily_rate" class="form-control" placeholder="$" id="daily_rate" value="<?php if($data): ?><?php echo e(convertCurrency($data->daily_rate)); ?><?php endif; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57"/> 
        </div>
      </div>
      
      <div class="clearboth"></div> 
      <label  class="small text-muted mt-4" for="hourly_rate"><b>Hourly Rate (<?php echo e(session()->get('user_currency')); ?>)</b></label>
      <div class="row mb-2">
        <div class="col-md-10 position-relative">
          <input type="number" name="hourly_rate" class="form-control" placeholder="$" id="hourly_rate" value="<?php if($data): ?><?php echo e(convertCurrency($data->hourly_rate)); ?><?php endif; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57"/>
        </div>
      </div>
    </form>
  </div>
</div>
<div class="row mt-3 usraction">
 
   <div class="col-md-6">
    <input id="btn_saveTeam" type="button" class="btn w-100 mb-2" value="Save Changes">
  </div>
 
</div>
<?php else: ?>
<div align="center">No data found</div>
<?php endif; ?><?php /**PATH /var/www/html/nomadic/resources/views/team/teamedit-card.blade.php ENDPATH**/ ?>