<?php if($data): ?>
<div class="row">
  <div class="col-md-7">
    <?php if($data->profile_pic): ?>
    <img src="<?php echo e(asset('storage/profile-pic')); ?>/<?php echo e($data->profile_pic); ?>" class="img-fluid" style="height:100%;">
    <?php else: ?>
    <img src="<?php echo e(asset('images/user-img.png')); ?>" class="img-fluid" style="height:100%;">
    <?php endif; ?>
  </div>
  <div class="col-md-5">
    <label class="small text-muted">Email</label>
    <div class="clearboth"></div>
    <label class="small text-muted">
      <?php if($data->email): ?><?php echo e($data->email); ?><?php else: ?> No email <?php endif; ?>
    </label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Member since</label>
    <div class="clearboth"></div>
    <label class="small text-muted"><?php echo e(date('M d, Y',strtotime($data->created_at))); ?></label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Total points</label>
    <div class="clearboth"></div>
    <label class="small text-muted"><?php echo e($current_balance); ?> pts</label>
    <div class="clearboth"></div>
    <label class="small text-muted mt-3">Membership level</label>
    <div class="clearboth"></div>
    <label class="small text-muted"><?php if($data->user_plan): ?><?php echo e($data->user_plan->name); ?><?php endif; ?></label>
  </div>
</div>
<div class="row">
  <div class="col-md-12 mt-5">
    <form id="updateUser">
      <?php echo csrf_field(); ?>
      <input type="hidden" id="user_uuid" name="user_uuid" value="<?php echo e($data->uuid); ?>" readonly>
      <label class="small text-muted">Name</label> 
      <div class="clearboth"></div>
      <label class="lblprofilebind"><?php echo e(ucfirst($data->fname)); ?> <?php echo e(ucfirst($data->lname)); ?></label>
      <div class="clearboth"></div>
      <label class="small text-muted">Role</label>
      <div class="clearboth"></div>
      <label class="lblprofilebind"><?php echo e(ucfirst($data->role)); ?></label>
      <div class="clearboth"></div>
      <?php if($user_permissions): ?>
      <label class="small text-muted mt-2">Existing Permission(s)</label>
      <div class="clearboth"></div>
      <label class="lblprofilebind">
        <ul>
          <?php $__currentLoopData = $user_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="small"><?php echo e($per['location']); ?>

            <ul>
              <?php $__currentLoopData = $per['roles']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li class="small"><?php echo e($role); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </label>
      <div class="clearboth"></div>
      <?php endif; ?>
      <label class="small text-muted mt-2">Add Permission(s)</label>
      <div class="clearboth"></div>
      <div class="row mb-2">
        <div class="col-md-6 position-relative">
          <select class="form-control" name="location">
            <option value="">Select Location</option>
            <?php if(in_array(auth()->user()->role,['super-admin','admin'])): ?>
            <option value="all">Change Role</option>
            <?php endif; ?>
            <?php $__currentLoopData = $location; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($key); ?>"><?php echo e($val); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
          <i class="bi bi-caret-down-fill searchicon"></i>
        </div>
        <div class="col-md-6 position-relative">
          <select class="form-control" name="role" data-done-button="true" multiple></select>
          <i class="bi bi-caret-down-fill searchicon"></i>
        </div>
      </div>
      <div class="clearboth"></div>
      <div class="position-relative mb-2">
        <input id="btn_addpermission" type="button" class="btn btn-primary mb-2 mt-4" value="Add Permission">
      </div>
      <div class="clearboth"></div>
      <label class="small text-muted mt-4">Add points</label>
      <div class="clearboth"></div>
      <div class="row mb-2">
        <div class="col-md-6">
          <input type="text" class="form-control" name="points" placeholder="Add points">
        </div>
        <div class="col-md-6">
          <input id="btn_addpoints" type="button" class="btn btn-primary" value="Add Points">
        </div>
      </div>
      <div class="clearboth"></div>
      <label class="small text-muted mt-4">Status</label>
      <div class="clearboth"></div>
      <label class="lblprofilebind txt-status">
        <?php if($data->status==2): ?><span class="txtApproved">Approved</span>
        <?php elseif($data->status==3): ?><span class="txtDenied">Denied</span>
        <?php elseif($data->status==4): ?><span class="txtDenied">Suspended</span>
        <?php elseif($data->status==5): ?><span class="txtDenied">Blocked</span>
        <?php endif; ?>
      </label>
    </form>
  </div>
</div>
<div class="row mt-3 usraction">
  <?php if($data->status!=4): ?>
  <div class="col-md-4">
    <input type="button" class="btn btn-dark btnappaction w-100 mb-2 btn-primary" data-type="muser" data-action="4" value="Suspend">
  </div>
  <?php endif; ?>
  <?php if($data->status!=5): ?>
  <div class="col-md-5">
    <input type="button" class="btn btn-danger btnappaction w-100 mb-2 btn-primary" data-type="muser" data-action="5" value="Block User">
  </div>
  <?php endif; ?>
  <?php if($data->status==4 || $data->status==5): ?>
  <div class="col-md-5">
    <input type="button" class="btn btn-success btnappaction w-100 mb-2 btn-primary" data-type="muser" data-action="2" value="Make Active">
  </div>
  <?php endif; ?>
</div>
<?php else: ?>
<div align="center">No data found</div>
<?php endif; ?><?php /**PATH /var/www/html/nomadic/resources/views/global/useredit-card.blade.php ENDPATH**/ ?>