<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Dynamic Metatags Start -->
    <?php $page_url = ltrim(str_replace(url('/'),'',url()->current()),'/'); ?>
    <?php if($page_url==""): ?>
    <meta name="title" content="<?php echo e($meta_tags['home']->title); ?>">
    <meta name="keywords" content="<?php echo e($meta_tags['home']->keywords); ?>">
    <meta name="description" content="<?php echo e($meta_tags['home']->description); ?>">
    <?php elseif(isset($meta_tags[$page_url])): ?>
    <meta name="title" content="<?php echo e($meta_tags[$page_url]->title); ?>">
    <meta name="keywords" content="<?php echo e($meta_tags[$page_url]->keywords); ?>">
    <meta name="description" content="<?php echo e($meta_tags[$page_url]->description); ?>">
    <?php endif; ?>
    <!-- Dynamic Metatags End-->
     
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <!-- 
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    -->
    <link rel="preload" href="https://fonts.cdnfonts.com/css/neue-haas-grotesk-display-pro" rel="stylesheet">
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.5.3.2.min.css')); ?>" defer=""> -->
    
    <link rel="preload" href="<?php echo e(asset('css/bootstrap.5.3.2.min.css')); ?>" as="style" onload="this.onload=null;this.rel='stylesheet'">
    <noscript><link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.5.3.2.min.css')); ?>"></noscript>
    
    <!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/bootstrap-icons.svg" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css" rel="stylesheet"> -->
    <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap-icons.min.css')); ?>">
    <!-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"> -->

    <link rel="stylesheet" href="<?php echo e(asset('css/swiper-bundle.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('css/equipment.3ba249e1.css')); ?>" defer="">
    <link rel="stylesheet" href="<?php echo e(asset('css/equipment.567bcd14.css')); ?>" defer="">
    <link rel="stylesheet" href="<?php echo e(asset('css/equipment.599ea170.css')); ?>" defer="">

    <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>" defer="">

<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">

    <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script> -->
    <script src="<?php echo e(asset('js/jquery.3.7.1.min.js')); ?>"></script> 
    <!-- <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script> -->
    
    <!-- <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script> -->
    <script src="<?php echo e(asset('js/swiper-bundle.min.js')); ?>" defer=""></script>
    <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js"></script> -->
    <script src="<?php echo e(asset('js/popper.min.js')); ?>" defer=""></script>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script> -->
    <script src="<?php echo e(asset('js/bootstrap.bundle.5.3.2.min.js')); ?>" defer=""></script>

    <!-- <script src="<?php echo e(asset('js/jquery-2.2.4.min.js')); ?>"></script> -->
    <script src="<?php echo e(asset('vendor/bootstrap/js/bootstrap-datepicker.min.js')); ?>" defer=""></script>
    <script src="<?php echo e(asset('js/jquery.validate.min.js')); ?>" defer=""></script>
    <script>
    var APP_URL = <?php echo json_encode(url('/')); ?>

    var _token = $('meta[name="csrf-token"]').attr('content');
    </script>
    <script src="<?php echo e(asset('js/nomadic.js')); ?>" ></script>
</head>
<body>

  <?php echo $__env->make('partials/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <main><?php echo $__env->yieldContent('content'); ?></main>
  <?php echo $__env->make('partials/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="modal fade" id="otp_modal" style="display:none;z-index:10000;"></div>
  <div class="modal fade" id="alertMsg" style="z-index:90000">
      <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content bdrradius">
          <div class="modal-body">
              <div class="mt-2 mb-4 pagemsgcontent"></div>
              <div class="text-center">
              <button type="button" class="btn btn-primary ml-2" data-bs-dismiss="modal">Ok</button>
              </div>
          </div>
          </div>
      </div>
  </div>
  <div class="modal" id="general_modal" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content bdrradius">
        <div class="modal-header">
          <h5 class="modal-title"></h5>
        </div>
        <div class="modal-body"></div>
        <div class="modal-footer">
          
        </div>
      </div>
    </div>
  </div>
  <div class="modal" id="guest_modal" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered modal-sm">
      <div class="modal-content lightgrey bdradius1">
        <div class="modal-body p-0 bdradius1">
          <p><i class="bi bi-x-lg popuclose pointer" data-bs-dismiss="modal" aria-label="Close"></i></p>
          <div class="md-container"></div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="enlargeImageModal">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Preview</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <img id="enlargedImage" src="" class="img-fluid rounded" alt="Enlarged Image">
        </div>
      </div>
    </div>
  </div>
  <!-- Start modal for Language and region -->
  <?php echo $__env->make('language_price', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!-- End modal for Language and region-->
  <div class="modal fade" id="createplanner" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="createplannerLabel" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen-md-down">
      <div class="modal-content">
        <div class="modal-header borderbottom">
          <h5 class="modal-title fw-bolder" id="createplannerLabel">Booking Details</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body" id="book_modal"></div>
      </div>
    </div>
  </div>
  
  <script>document.addEventListener("DOMContentLoaded",()=>{setTimeout(()=>{let e=document.querySelector("main .hero-section");e&&e.classList.add("visible")},500),setTimeout(()=>{let e=document.querySelector("main .hero-section + section");e&&e.classList.add("visible")},1500),(()=>{let e=document.getElementById("video"),t=document.getElementById("playPauseBtn"),n=document.querySelector(".video-container");t&&t.addEventListener("click",()=>{e.paused||e.ended?(e.play(),n.classList.add("playing")):(e.pause(),n.classList.remove("playing"))}),e&&e.addEventListener("play",()=>{n.classList.add("playing")}),e&&e.addEventListener("pause",()=>{n.classList.remove("playing")})})()}),document.addEventListener("DOMContentLoaded",()=>{let e=document.querySelectorAll(".image-container img"),t=0;e[0]&&e[t].classList.add("active"),e.length&&setInterval(function(){e[t].classList.remove("active"),t=(t+1)%e.length,e[t].classList.add("active")},3e3)}),document.addEventListener("DOMContentLoaded",()=>{let e=document.querySelectorAll(".image-container-zooming img"),t=0;e[0]&&e[t].classList.add("active"),e.length&&setInterval(function(){e[t].classList.remove("active"),t=(t+1)%e.length,e[t].classList.add("active")},3e3)}),document.addEventListener("scroll",()=>{document.querySelectorAll("main > section:not(.hero-section)").forEach(e=>{let t=e.getBoundingClientRect(),n=window.innerHeight||document.documentElement.clientHeight;t.top<n-150&&e.classList.add("visible")})}),document.addEventListener("scroll",()=>{document.querySelectorAll("main > section:not(.hero-section) h2").forEach(e=>{let t=e.getBoundingClientRect(),n=window.innerHeight||document.documentElement.clientHeight;t.top<n-200&&e.classList.add("visible")})}),document.addEventListener("scroll",()=>{document.querySelectorAll("main > section:not(.hero-section) h2 + p").forEach(e=>{let t=e.getBoundingClientRect(),n=window.innerHeight||document.documentElement.clientHeight;t.top<n-250&&e.classList.add("visible")})}),document.addEventListener("scroll",()=>{document.querySelectorAll("main > section:not(.hero-section) .section-btn").forEach(e=>{let t=e.getBoundingClientRect(),n=window.innerHeight||document.documentElement.clientHeight;t.top<n-200&&e.classList.add("visible")})}),document.addEventListener("scroll",()=>{document.querySelectorAll("main > section:not(.hero-section) .section-fade-img-left").forEach(e=>{let t=e.getBoundingClientRect(),n=window.innerHeight||document.documentElement.clientHeight;t.top<n-250&&e.classList.add("visible")})}),document.addEventListener("scroll",()=>{document.querySelectorAll("main > section:not(.hero-section) .section-fade-img-right").forEach(e=>{let t=e.getBoundingClientRect(),n=window.innerHeight||document.documentElement.clientHeight;t.top<n-250&&e.classList.add("visible")})});</script>
  <script src="<?php echo e(asset('js/equipment.2818901c.js')); ?>" type="module" defer=""></script>
  <script src="<?php echo e(asset('js/equipment.fd225706.js')); ?>" defer="" nomodule=""></script>
  <script src="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js"></script>
  <?php echo $__env->yieldContent('footer_scripts'); ?>

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-0QXQMMNG0E"></script>
  <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'G-0QXQMMNG0E');
  </script>
</body>
</html><?php /**PATH /var/www/html/nomadic/resources/views/layouts/main.blade.php ENDPATH**/ ?>