
<?php $__env->startSection('title', 'Booking | Select studio'); ?>
<?php $__env->startSection('content'); ?>
<div class="banner">
    <div class="img-text img-margin"><?php echo e(__('Create something with us!')); ?></div>
    <img class="img-fluid w-100" src="<?php echo e(asset('images/booking-banner.png')); ?>">
</div>

<section class="visible">
    <div class="container text-dark mt-3" data-aos="fade-up">
        <div class="row">
            <div class="col-md-8">
                <?php if($studios->count() > 0): ?>
                <h2 class="mb-4">Select type of studio</h2>
                <?php $__currentLoopData = $studios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row col-md-12 mt-3 <?php if(!$studio->available): ?> text-muted <?php endif; ?>">
                    <div class="col-md-1">
                        <div>
                            <input id="checkbox-<?php echo e($loop->index); ?>" class="checkbox-custom" value="<?php echo e($studio->id); ?>" name="booking_studio" type="radio" data-type="studio" data-days="<?php echo e($studio->booking_days); ?>" data-hours="<?php echo e($studio->booking_hours); ?>" <?php if(session()->has('temp-booking-studio-selection') && session()->get('temp-booking-studio-selection')==$studio->id): ?>checked <?php endif; ?> <?php if(!$studio->available): ?> disabled <?php endif; ?>>
                            <label for="checkbox-<?php echo e($loop->index); ?>" class="checkbox-custom-label"></label>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <h3><?php echo e($studio->name); ?></h3>
                        <?php if(!$studio->available): ?>
                        <p>studio is booked at this time please select different time. <span class="text-primary pointer check-availability">check availability</span></p>
                        <div class="availability-calendar" data-id="<?php echo e($studio->id); ?>" data-type="studio"></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-2">
                        <h3><?php echo e($studio->studio_points); ?>pts</h3>
                    </div>
                    <div class="col-md-4">
                        <div class="imgbox">
                            <img src="<?php echo e(url('storage/location/'.$studio->landingPage->banner_picture)); ?>" class="imgfluidlogged <?php if(!$studio->available): ?> opacity-50 <?php endif; ?>" />
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="row col-md-12 mt-5">
                    <div class="foot-paging">
                    <?php echo $studios->withQueryString()->links('vendor.pagination.bootstrap-5'); ?>

                    </div>
                </div>
                <?php else: ?>
                <h2 class="mt-4">Studios are not available this time.</h2>
                <?php endif; ?>
            </div>
            <div class="col-md-4 p-0">
                <?php echo $__env->make('frontend.booking.booking-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script>
    $(document).ready(function () {
        
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/frontend/booking/studio.blade.php ENDPATH**/ ?>