
<?php $__env->startSection('title', 'Nomadic-Location'); ?>
<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1><?php echo e($location->location); ?> Landing Page</h1>
</div>

<section class="section profile">
  <div class="col-xl-12">
    <input type="hidden" id="type" name="type" value="location" readonly>
    <input type="hidden" id="lpid" name="lpid" value="<?php if($page): ?><?php echo e($page->id); ?><?php endif; ?>" readonly>
    <input type="hidden" id="location_id" name="location_id" value="<?php if($location): ?><?php echo e($location->id); ?><?php endif; ?>" readonly>
    
    <?php if(session('success')): ?>
    <div class="alert alert-success p-2"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    
    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
              <label class="lblprofile">Location</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative"><?php echo e($location->location); ?></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Banner Picture</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div id="dispbannerimg" class="mb-3">
        <?php if(isset($page->banner_picture) && $page->banner_picture!=""): ?>
          <img src="<?php echo e(asset('storage/location')); ?>/<?php echo e($page->banner_picture); ?>" class="img-fluid w-75" style="border-radius:5px;">
        <?php endif; ?>
        </div>
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="<?php echo e(url('fileupload')); ?>" method="post" enctype="multipart/form-data" id="banner_picture" class="dropzone">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="image_type" value="banner" readonly>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Carousel Photos</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <form action="<?php echo e(url('fileupload')); ?>" method="post" enctype="multipart/form-data" id="gallery" class="dropzone">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="image_type" value="gallery" readonly>
                </form>
                <div id="galleryimages"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Studios</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <?php $__currentLoopData = $studios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div>
                    <input id="checkbox-1<?php echo e($loop->index); ?>" class="checkbox-custom" value="<?php echo e($studio->id); ?>" name="studios[]" type="checkbox" <?php if(strpos($page->studios,$studio->id) !== false): ?> checked <?php endif; ?>>
                    <label for="checkbox-1<?php echo e($loop->index); ?>" class="checkbox-custom-label"><?php echo e($studio->name); ?></label> 
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Our Crew</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <?php $__currentLoopData = $resources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div>
                    <input id="checkbox-2<?php echo e($loop->index); ?>" class="checkbox-custom" name="crew[]" type="checkbox" value="<?php echo e($resource->id); ?>" <?php if(strpos($page->our_crew,$resource->id) !== false): ?> checked <?php endif; ?>>
                    <label for="checkbox-2<?php echo e($loop->index); ?>" class="checkbox-custom-label"><?php echo e(__($resource->name)); ?></label> 
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-xl-4">
        <div class="card">
          <div class="card-body profile-card pt-4 pl-0 d-flex flex-column">
            <label class="lblprofile">Key Information</label>
          </div>
        </div>
      </div>
      <div class="col-xl-8 mt-4">
        <div class="card">
          <div class="card-body pt-3">
            <div class="row">
              <div class="col-md-7 mb-2 position-relative">
                <label>Address</label>
                <input type="text" class="form-control" name="address" placeholder="Address" value="<?php if(isset($page->address)): ?><?php echo e($page->address); ?><?php endif; ?>" />
                <label class="mt-3">Opening hours</label></br>
                <textarea name="opening_hours" class="form-control txtarea mb-3" rows="4" placeholder="Opening hours"><?php if(isset($page->opening_hours)): ?><?php echo e($page->opening_hours); ?><?php endif; ?></textarea>
                <label class="mt-3">Phone</label></br>
                <input type="text" class="form-control" name="phone" placeholder="Phone" value="<?php if(isset($page->phone)): ?><?php echo e($page->phone); ?><?php endif; ?>" />
                <label class="mt-3">Email</label></br>
                <input type="text" class="form-control" name="email" placeholder="Email address" value="<?php if(isset($page->email)): ?><?php echo e($page->email); ?><?php endif; ?>"/>
                <label class="mt-3">How to get there</label></br>
                <textarea name="how_to_get_there" class="form-control txtarea mb-3" rows="4" placeholder="Hot to get there"><?php if(isset($page->how_to_get_there)): ?><?php echo e($page->how_to_get_there); ?><?php endif; ?></textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
    <div class="row mt-3">
      <div class="col-md-12 text-center">
        <input id="btn_saveloclandingpage" type="button" class="btn btn-primary mb-2 mt-4" value="Save changes">
      </div>
    </div>

  </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer_scripts'); ?>
<!-- <script src="https://cdn.tiny.cloud/1/7oxmjjhuf38181ubsazv0hcwhi602g0gw8bbalyo8kvqttzl/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  tinyMCE.init({
    selector: 'textarea#quill-editor-default, textarea#quill-editor-default2',
    plugins: 'anchor autolink link code',
    menubar: '',
    toolbar: 'bold italic underline link bullist code',
  });
</script> -->
<link href="<?php echo e(asset('css/dropzone.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('css/dropzone.custom.css')); ?>" rel="stylesheet">
<script src="<?php echo e(asset('js/dropzone.js')); ?>"></script>
<script src="<?php echo e(asset('js/cropper.js')); ?>"></script>
<link href="<?php echo e(asset('css/cropper.css')); ?>" rel="stylesheet">
<script>
  Dropzone.autoDiscover = false;
  var myDropzone = new Dropzone("#banner_picture",{ 
    maxFiles: 1,
    maxFilesize: 100,
    autoProcessQueue: true,
    uploadMultiple: false, 
    addRemoveLinks: true,
    acceptedFiles: ".jpeg,.jpg,.png",
    transformFile: function(file, done) {
      cropperImageFunc(file, done, this, 1, 600, 600);
    }
  });
  myDropzone.on("sending", function(file, xhr, formData) {
      formData.append("type", $('#type').val());
      //formData.append("image_type", 'banner');
      formData.append("lpid", $('#lpid').val());
      formData.append("location_id", $('#location_id').val());
  });
  myDropzone.on("uploadprogress", function (file, progress) {
      $('.progress-text').html(parseInt(progress)+'%');
  });
  myDropzone.on("error", function (file, errorMessage) {
      $('.progress-text').html('0%').hide();
  });
  myDropzone.on("success", function (file, response) {
    $('.progress-text').html('0%').hide();
    $('#lpid').val(response.lpid);
    $('#dispbannerimg').html('<img src="'+APP_URL+'/'+response.imgurl+'" class="img-fluid w-75" style="border-radius:5px;">');
    myDropzone.removeAllFiles(true);
  });

  // carousel photos
  var myDropzone2 = new Dropzone("#gallery",{ 
      maxFiles: 10,
      maxFilesize: 100,
      autoProcessQueue: true,
      uploadMultiple: false, 
      addRemoveLinks: true,
      acceptedFiles: ".jpeg,.jpg,.png",
      transformFile: function(file, done) {
        let aRatio = 16/9;
        cropperImageFunc(file, done, this, aRatio, 491, 276);
      }
  });
  myDropzone2.on("sending", function(file, xhr, formData) {
      formData.append("type", $('#type').val());
      //formData.append("image_type", 'banner');
      formData.append("lpid", $('#lpid').val());
      formData.append("location_id", $('#location_id').val());
  });
  myDropzone2.on("uploadprogress", function (file, progress) {
      $('.progress-text').html(parseInt(progress)+'%');
  });
  myDropzone2.on("error", function (file, errorMessage) {
      $('.progress-text').html('0%').hide();
  });
  myDropzone2.on("success", function (file, response) {
    $('.progress-text').html('0%').hide();
    $('#lpid').val(response.lpid);
    myDropzone2.removeAllFiles(true);
    gallery_images('location','gallery',response.lpid,'galleryimages');
  });

  $(document).ready(function () {
    let lpid = $('#lpid').val();
    if(lpid!=""){
      gallery_images('location','gallery',lpid,'galleryimages');
    }

    $(document).on('click','#btn_saveloclandingpage',function(){
      let lpid = $('#lpid').val();
      let location_id = $('#location_id').val();
      let phone = $('input[name="phone"]').val();
      let email = $('input[name="email"]').val();
      let address = $('input[name="address"]').val();
      let opening_hours = $('textarea[name="opening_hours"]').val();
      let how_to_get_there = $('textarea[name="how_to_get_there"]').val();
      let studios = $('input[name="studios[]"]:checked').map(function() {
        return this.value;
      }).get();
      let crew = $('input[name="crew[]"]:checked').map(function() {
        return this.value;
      }).get()
      
      $.ajax({
        type: 'POST',
        dataType: 'json',
        data: {_token:_token, lpid:lpid, phone:phone, email:email, address:address, opening_hours:opening_hours, studios:studios, our_crew:crew, how_to_get_there:how_to_get_there},
        url: APP_URL+"/backend/location-landing-page-save/"+location_id,
        success: function(res) {
          if(res.status){
            $('#alertMsg .pagemsgcontent').html('<div class="alert alert-success">'+res.message+'</div>');
            $('#alertMsg').modal('show');
          }
        },
        error: function(res) {                    
          ajax_error(res);
        }
      });
    });
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/nomadic/resources/views/content-editing/location-landing-page.blade.php ENDPATH**/ ?>